/*
 * Decompiled with CFR 0.152.
 */
package de.tblsoft.solr.pipeline.filter;

import de.tblsoft.solr.pipeline.AbstractFilter;
import de.tblsoft.solr.pipeline.bean.Document;
import java.util.ArrayList;
import java.util.List;

public class OffsetPermutationFilter
extends AbstractFilter {
    private long offset;
    private List<String> fields;
    List<Document> previousDocs;

    @Override
    public void init() {
        this.offset = this.getPropertyAsInt("offset", 1);
        this.fields = this.getPropertyAsList("fields", null);
        this.verify(this.fields, "For the OffsetPermutationFilter fields must be defined!");
        this.previousDocs = new ArrayList<Document>();
        super.init();
    }

    @Override
    public void document(Document doc) {
        if ((long)this.previousDocs.size() >= this.offset && this.previousDocs.size() > 0) {
            Document previousDoc = this.previousDocs.remove(0);
            Document permutedDoc = OffsetPermutationFilter.permuteDocument(doc, previousDoc, this.fields);
            super.document(permutedDoc);
        }
        this.previousDocs.add(doc);
    }

    protected static Document permuteDocument(Document currentDoc, Document previousDoc, List<String> fields) {
        Document result = new Document(currentDoc);
        if (previousDoc != null) {
            for (String field : fields) {
                result.setField(field, previousDoc.getFieldValues(field));
            }
        }
        return result;
    }
}

