/*
 * Decompiled with CFR 0.152.
 */
package de.tblsoft.solr.pipeline.filter;

import de.tblsoft.solr.pipeline.AbstractFilter;
import de.tblsoft.solr.pipeline.bean.Document;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegexFindFilter
extends AbstractFilter {
    private Pattern regex;
    private String sourceField;
    private String destField;

    @Override
    public void init() {
        String regexString = this.getProperty("regex", null);
        this.verify(regexString, "For the RegexFindFilter a regex property must be defined.");
        this.regex = Pattern.compile(regexString);
        this.sourceField = this.getProperty("sourceField", null);
        this.verify(this.sourceField, "For the RegexFindFilter a sourceField property must be defined.");
        this.destField = this.getProperty("destField", this.sourceField);
        super.init();
    }

    @Override
    public void document(Document document) {
        String value = document.getFieldValue(this.sourceField);
        if (value != null) {
            if (document.getFieldValues(this.destField) != null) {
                document.getFieldValues(this.destField).clear();
            }
            Matcher m = this.regex.matcher(value);
            while (m.find()) {
                String extractedValue = m.group();
                document.addField(this.destField, extractedValue);
            }
        }
        super.document(document);
    }
}

