/*
 * Decompiled with CFR 0.152.
 */
package de.tblsoft.solr.pipeline.filter;

import de.tblsoft.solr.pipeline.AbstractFilter;
import de.tblsoft.solr.pipeline.bean.Document;
import java.util.List;
import java.util.regex.Pattern;

public class RegexReplaceFilter
extends AbstractFilter {
    private Pattern regex;
    private String replacement;
    private List<String> fields;

    @Override
    public void init() {
        String regexString = this.getProperty("regex", null);
        this.verify(regexString, "For the RegexSplitFilter a regex property must be defined!");
        this.regex = Pattern.compile(regexString);
        this.replacement = this.getProperty("replacement", "");
        this.fields = this.getPropertyAsList("fields", null);
        this.verify(this.fields, "For the RegexSplitFilter a fields property must be defined!");
        super.init();
    }

    @Override
    public void document(Document document) {
        for (String field : this.fields) {
            List<String> fieldValues = document.getFieldValues(field);
            if (fieldValues == null) continue;
            for (int i = 0; i < fieldValues.size(); ++i) {
                String value = fieldValues.get(i);
                value = value.replaceAll(this.regex.pattern(), this.replacement);
                fieldValues.set(i, value);
            }
        }
        super.document(document);
    }
}

