/*
 * Decompiled with CFR 0.152.
 */
package de.tblsoft.solr.pipeline.filter;

import de.tblsoft.solr.pipeline.AbstractFilter;
import de.tblsoft.solr.pipeline.bean.Document;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegexSplitFilter
extends AbstractFilter {
    private Pattern regex;
    private String sourceField;
    private List<String> destFieldList;
    private List<String> notMatchedDestFieldList;
    private boolean splitArray;

    @Override
    public void init() {
        String regexString = this.getProperty("regex", null);
        this.verify(regexString, "For the RegexSplitFilter a regex property must be defined.");
        this.regex = Pattern.compile(regexString);
        this.sourceField = this.getProperty("sourceField", null);
        this.verify(this.sourceField, "For the RegexSplitFilter a sourceField property must be defined.");
        this.destFieldList = this.getPropertyAsList("destFieldList", null);
        this.verify(this.destFieldList, "For the RegexSplitFilter a destFieldList property must be defined as list.");
        this.notMatchedDestFieldList = this.getPropertyAsList("notMatchedDestFieldList", new ArrayList<String>());
        this.splitArray = this.getPropertyAsBoolean("splitArray", false);
        super.init();
    }

    @Override
    public void document(Document document) {
        List<String> fieldValues = document.getFieldValues(this.sourceField);
        if (fieldValues != null && this.splitArray && fieldValues.size() > 1) {
            for (String value : fieldValues) {
                Document copy = new Document(document);
                this.splitDocument(copy, value);
                super.document(copy);
            }
        } else {
            String value = document.getFieldValue(this.sourceField, "");
            this.splitDocument(document, value);
            super.document(document);
        }
    }

    protected void splitDocument(Document document, String value) {
        Matcher m = this.regex.matcher(value);
        if (m.matches()) {
            for (int i = 0; i < m.groupCount(); ++i) {
                String extractedValue = m.group(i + 1);
                String fieldName = this.destFieldList.get(i);
                document.addField(fieldName, extractedValue);
            }
        } else {
            for (String fieldName : this.notMatchedDestFieldList) {
                document.addField(fieldName, value);
            }
        }
    }
}

