/*
 * Decompiled with CFR 0.152.
 */
package de.tblsoft.solr.pipeline.filter;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import de.tblsoft.solr.http.UrlUtil;
import de.tblsoft.solr.pipeline.AbstractFilter;
import de.tblsoft.solr.pipeline.bean.Document;
import de.tblsoft.solr.pipeline.bean.Field;
import de.tblsoft.solr.pipeline.filter.RestWorker;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestFilter
extends AbstractFilter {
    private static Logger LOG = LoggerFactory.getLogger(RestFilter.class);
    private String url;
    private String method;
    private List<String> headers;
    private List<String> payload;
    private List<String> filters;
    private int timeout;
    private int threads;
    private String responsePrefix;
    private CloseableHttpClient httpclient;
    private ExecutorService executor;
    private Gson gson;

    @Override
    public void init() {
        this.url = this.getProperty("url", null);
        this.verify(this.url, "For the RestFilter a url must be defined!");
        this.method = this.getProperty("method", "GET");
        this.payload = this.getPropertyAsList("payload", null);
        ArrayList<String> defaultHeaders = new ArrayList<String>();
        if (this.payload != null) {
            defaultHeaders.add("Content-type: application/json");
        }
        this.headers = this.getPropertyAsList("headers", defaultHeaders);
        this.filters = this.getPropertyAsList("filters", null);
        this.timeout = this.getPropertyAsInt("timeout", 10000);
        this.threads = this.getPropertyAsInt("threads", 1);
        this.responsePrefix = this.getProperty("responsePrefix", null);
        PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager();
        cm.setMaxTotal(this.threads);
        cm.setDefaultMaxPerRoute(this.threads);
        this.httpclient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)cm).setMaxConnPerRoute(this.threads).setDefaultRequestConfig(RequestConfig.custom().setSocketTimeout(this.timeout).setConnectTimeout(this.timeout).setConnectionRequestTimeout(this.timeout).build()).build();
        ThreadFactory namedThreadFactory = new ThreadFactoryBuilder().setNameFormat("tblsoft-rest-filter-thread-%d").build();
        this.executor = Executors.newFixedThreadPool(this.threads, namedThreadFactory);
        LOG.info("start http filter with threads: " + this.threads);
        this.gson = new GsonBuilder().create();
        super.init();
    }

    @Override
    public void document(Document doc) {
        if (this.filterMatch(doc)) {
            RestWorker.RestRequest request = this.buildRequest(doc);
            RestWorker worker = new RestWorker(doc, this.httpclient, request, this.responsePrefix, this.nextFilter);
            Future<Document> future = this.executor.submit(worker);
        } else {
            super.document(doc);
        }
    }

    protected boolean filterMatch(Document doc) {
        boolean match = true;
        for (String filter : this.filters) {
            String[] split = filter.split(":");
            if (split.length != 2) continue;
            String field = split[0];
            String value = split[1];
            String fieldValue = doc.getFieldValue(field);
            match &= StringUtils.equals((CharSequence)fieldValue, (CharSequence)value);
        }
        return match;
    }

    protected RestWorker.RestRequest buildRequest(Document doc) {
        String urlWithParams = this.buildUrlWithParams(doc);
        String payload = this.buildPayload(doc);
        RestWorker.RestRequest request = new RestWorker.RestRequest(urlWithParams, this.method, this.headers, payload);
        return request;
    }

    protected String buildUrlWithParams(Document doc) {
        String url = this.getUrl(doc);
        for (Field field : doc.getFields()) {
            String fieldPattern = "\\{" + field.getName() + "\\}";
            String urlEncodedValue = UrlUtil.encode(field.getValue());
            url = url.replaceAll(fieldPattern, urlEncodedValue);
        }
        return url;
    }

    protected String getUrl(Document doc) {
        return doc.getFieldValue(this.url, this.url);
    }

    protected String buildPayload(Document doc) {
        String jsonPayload = null;
        if (this.payload != null) {
            HashMap<String, Object> payloadMap = new HashMap<String, Object>();
            for (String fieldName : this.payload) {
                List<String> fieldValues = doc.getFieldValues(fieldName);
                if (fieldValues != null && fieldValues.size() > 1) {
                    payloadMap.put(fieldName, fieldValues);
                    continue;
                }
                payloadMap.put(fieldName, fieldValues.get(0));
            }
            jsonPayload = this.gson.toJson(payloadMap);
        }
        return jsonPayload;
    }

    @Override
    public void end() {
        try {
            this.httpclient.close();
        }
        catch (IOException e) {
            LOG.info(e.getMessage());
        }
        this.executor.shutdown();
        super.end();
    }
}

