/*
 * Decompiled with CFR 0.152.
 */
package de.tblsoft.solr.pipeline.filter;

import de.tblsoft.solr.pipeline.FilterIF;
import de.tblsoft.solr.pipeline.bean.Document;
import de.tblsoft.solr.util.DateUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;

public class RestWorker
implements Callable<Document> {
    private Document doc;
    private CloseableHttpClient httpclient;
    private RestRequest request;
    private String responsePrefix;
    private FilterIF filter;

    public RestWorker(Document doc, CloseableHttpClient httpclient, RestRequest request, String responsePrefix, FilterIF filter) {
        this.doc = doc;
        this.httpclient = httpclient;
        this.request = request;
        this.responsePrefix = responsePrefix;
        this.filter = filter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Document call() throws Exception {
        HttpUriRequest httpUriRequest = this.buildRequest();
        CloseableHttpResponse response = null;
        try {
            long start = System.currentTimeMillis();
            response = this.httpclient.execute(httpUriRequest);
            if (this.responsePrefix != null) {
                this.enrichDocWithResponse((HttpResponse)response);
                long duration = System.currentTimeMillis() - start;
                this.doc.setField(this.responsePrefix + "duration", String.valueOf(duration));
            }
        }
        catch (IOException e) {
            if (this.responsePrefix != null) {
                this.doc.addField(this.responsePrefix + "error_msg", e.getMessage());
            }
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException iOException) {}
            }
        }
        this.filter.document(this.doc);
        return this.doc;
    }

    protected void enrichDocWithResponse(HttpResponse response) throws IOException {
        StringBuilder responseBuilder = new StringBuilder();
        responseBuilder.append(EntityUtils.toString((HttpEntity)response.getEntity()));
        for (Header header : response.getAllHeaders()) {
            this.doc.addField(this.responsePrefix + "header_" + header.getName(), header.getValue());
            this.doc.addField(this.responsePrefix + "headers", header.getName());
        }
        this.doc.setField(this.responsePrefix + "size", String.valueOf(responseBuilder.length()));
        this.doc.setField(this.responsePrefix + "code", String.valueOf(response.getStatusLine().getStatusCode()));
        this.doc.setField(this.responsePrefix + "payload", responseBuilder.toString());
        this.doc.setField(this.responsePrefix + "time", DateUtils.date2String(new Date()));
    }

    protected HttpUriRequest buildRequest() {
        RequestBuilder requestBuilder = RequestBuilder.create((String)this.request.method).setUri(this.request.url);
        for (String header : this.request.headers) {
            String[] split = header.split(":");
            if (split.length != 2) continue;
            requestBuilder.addHeader(split[0], split[1]);
        }
        if (this.request.payload != null && this.request.payload instanceof String) {
            ByteArrayEntity jsonEntity = null;
            try {
                jsonEntity = new ByteArrayEntity(this.request.payload.toString().getBytes("UTF-8"));
                requestBuilder.setEntity((HttpEntity)jsonEntity);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return requestBuilder.build();
    }

    public static class RestRequest {
        String url;
        String method;
        List<String> headers;
        Object payload;

        public RestRequest(String url, String method, List<String> headers, Object payload) {
            this.url = url;
            this.method = method;
            this.headers = headers;
            this.payload = payload;
        }
    }
}

