/*
 * Decompiled with CFR 0.152.
 */
package de.tblsoft.solr.pipeline.filter;

import de.tblsoft.solr.pipeline.AbstractFilter;
import de.tblsoft.solr.pipeline.bean.Document;
import de.tblsoft.solr.pipeline.bean.DocumentBuilder;
import de.tblsoft.solr.util.IOUtils;
import java.io.File;
import java.util.ArrayList;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import org.apache.commons.io.FileUtils;
import org.jsoup.parser.Parser;

public class RichJavaScriptFilter
extends AbstractFilter {
    private String filename;
    private String script;
    private ScriptEngine engine;
    private CompiledScript compiledScript;
    Parser htmlParser;
    Parser xmlParser;

    @Override
    public void init() {
        String internalFilename = this.getProperty("filename", null);
        this.script = this.getProperty("script", null);
        ScriptEngineManager mgr = new ScriptEngineManager();
        this.engine = mgr.getEngineByName("JavaScript");
        this.htmlParser = Parser.htmlParser();
        this.xmlParser = Parser.xmlParser();
        try {
            if (internalFilename != null) {
                this.filename = IOUtils.getAbsoluteFile(this.getBaseDir(), internalFilename);
                this.script = FileUtils.readFileToString((File)new File(this.filename));
            }
            Compilable compEngine = (Compilable)((Object)this.engine);
            this.compiledScript = compEngine.compile(this.script);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        super.init();
    }

    @Override
    public void document(Document document) {
        ArrayList<Document> docs = new ArrayList<Document>();
        docs.add(document);
        try {
            this.engine.put("htmlParser", this.htmlParser);
            this.engine.put("xmlParser", this.xmlParser);
            this.engine.put("docs", docs);
            this.engine.put("documentBuilder", new DocumentBuilder());
            this.compiledScript.eval();
            for (Document d : docs) {
                super.document(d);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void end() {
        super.end();
    }
}

