/*
 * Decompiled with CFR 0.152.
 */
package de.tblsoft.solr.pipeline.filter;

import de.tblsoft.solr.pipeline.AbstractFilter;
import de.tblsoft.solr.pipeline.bean.Document;
import java.util.List;

public class RoundNumberFilter
extends AbstractFilter {
    String field;

    @Override
    public void init() {
        this.field = this.getProperty("field", null);
        this.verify(this.field, "A field must be defined!");
        super.init();
    }

    @Override
    public void document(Document document) {
        List<String> fieldValues;
        if (document != null && (fieldValues = document.getFieldValues(this.field)) != null) {
            for (int i = 0; i < fieldValues.size(); ++i) {
                String value = fieldValues.get(i);
                try {
                    Double numericValue = Double.parseDouble(value);
                    Long roundValue = Math.round(numericValue);
                    value = roundValue.toString();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                fieldValues.set(i, value);
            }
        }
        super.document(document);
    }
}

