/*
 * Decompiled with CFR 0.152.
 */
package de.tblsoft.solr.pipeline.filter;

import de.tblsoft.solr.pipeline.AbstractFilter;
import de.tblsoft.solr.pipeline.bean.Document;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class SimpleGenderFilter
extends AbstractFilter {
    private String fieldName;
    private List<String> replaceableWords;
    private List<String> trimEndings;
    private String separator;

    @Override
    public void init() {
        this.setFieldName(this.getProperty("fieldName", null));
        this.verify(this.getFieldName(), "For the SimpleGenderFilter a fieldName property must be defined.");
        this.setReplaceableWords(this.getPropertyAsList("replaceableWords", new ArrayList<String>()));
        this.setTrimEndings(this.getPropertyAsList("trimEndings", Arrays.asList("e")));
        this.setSeparator(this.getProperty("separator", "/-"));
        super.init();
    }

    @Override
    public void document(Document document) {
        List<String> values = document.getFieldValues(this.getFieldName(), new ArrayList<String>());
        if (values != null) {
            ArrayList<String> filteredValues = new ArrayList<String>();
            for (String value : values) {
                List<String> filteredGenderValues = this.filterGender(value);
                filteredValues.addAll(filteredGenderValues);
            }
            document.setField(this.getFieldName(), (List<String>)filteredValues);
        }
        super.document(document);
    }

    protected List<String> filterGender(String value) {
        ArrayList<String> values = null;
        if (value != null) {
            values = new ArrayList<String>();
            if (value.contains("/-")) {
                String[] tokens = value.split("/-");
                if (tokens.length == 2) {
                    String maleToken = tokens[0];
                    String femaleToken = tokens[1];
                    values.add(maleToken);
                    String femaleWord = this.buildFemaleWord(maleToken, femaleToken);
                    values.add(femaleWord);
                }
            } else {
                values.add(value);
            }
        }
        return values;
    }

    protected String buildFemaleWord(String maleWord, String femaleToken) {
        String result = null;
        boolean wordReplaced = false;
        for (String replaceableWord : this.getReplaceableWords()) {
            if (!StringUtils.containsIgnoreCase((CharSequence)maleWord, (CharSequence)replaceableWord)) continue;
            result = maleWord.replaceAll("(?i)" + replaceableWord, femaleToken);
            wordReplaced = true;
            break;
        }
        if (!wordReplaced) {
            for (String ending : this.getTrimEndings()) {
                if (!maleWord.endsWith(ending)) continue;
                maleWord = maleWord.substring(0, maleWord.length() - ending.length());
            }
            result = maleWord + femaleToken;
        }
        return result;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public List<String> getReplaceableWords() {
        return this.replaceableWords;
    }

    public void setReplaceableWords(List<String> replaceableWords) {
        this.replaceableWords = replaceableWords;
    }

    public List<String> getTrimEndings() {
        return this.trimEndings;
    }

    public void setTrimEndings(List<String> trimEndings) {
        this.trimEndings = trimEndings;
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }
}

