/*
 * Decompiled with CFR 0.152.
 */
package de.tblsoft.solr.pipeline.filter;

import com.google.common.base.Strings;
import de.tblsoft.solr.http.UrlUtil;
import de.tblsoft.solr.pipeline.bean.Field;
import de.tblsoft.solr.util.DateUtils;
import de.tblsoft.solr.util.MapUtils;
import de.tblsoft.solr.util.PairBuilder;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;

public class SimpleMapping {
    private Map<String, List<String>> mapping = new HashMap<String, List<String>>();
    private Map<String, List<String>> mappingFunctions = new HashMap<String, List<String>>();
    private Map<String, String> joins = new HashMap<String, String>();
    private Map<String, String> config = new HashMap<String, String>();
    private List<String> mappingDefinition;
    private List<String> mappingConfiguration;

    public SimpleMapping() {
    }

    public SimpleMapping(List<String> mappingDefinition, List<String> mappingConfiguration) {
        this.mappingConfiguration = mappingConfiguration;
        this.mappingDefinition = mappingDefinition;
        this.readConfig();
    }

    private void readConfig() {
        for (String configDefinition : this.mappingConfiguration) {
            Pair<String, String> p = PairBuilder.createPair(configDefinition, "=");
            this.config.put((String)p.getLeft(), (String)p.getValue());
        }
        for (String v : this.mappingDefinition) {
            String[] s;
            if (v.startsWith("join:")) {
                v = v.replace("join:", "");
                s = v.split("=", 2);
                this.joins.put(s[0], s[1]);
                continue;
            }
            s = v.split("->");
            String[] f = s[1].split(Pattern.quote("|"));
            List<String> mappingList = this.mapping.get(s[0]);
            if (mappingList == null) {
                mappingList = new ArrayList<String>();
            }
            mappingList.add(f[0]);
            this.mapping.put(s[0], mappingList);
            ArrayList<String> functions = new ArrayList<String>();
            for (int i = 1; i < f.length; ++i) {
                functions.add(f[i]);
            }
            this.mappingFunctions.put(f[0], functions);
        }
    }

    public String executeFunction(String function, String value) {
        if (Strings.isNullOrEmpty((String)function)) {
            return value;
        }
        if ("md5".equals(function)) {
            return DigestUtils.md5Hex((String)value);
        }
        if ("base64Encode".equals(function)) {
            return Base64.getEncoder().encodeToString(value.getBytes());
        }
        if ("base64Decode".equals(function)) {
            return new String(Base64.getDecoder().decode(value));
        }
        if ("mapGermanChars".equals(function)) {
            return SimpleMapping.mapGermanChars(value);
        }
        if ("mapFranceChars".equals(function)) {
            return SimpleMapping.mapFranceChars(value);
        }
        if ("lowercase".equals(function)) {
            return StringUtils.lowerCase((String)value);
        }
        if ("urlencode".equals(function)) {
            return UrlUtil.encode(value);
        }
        if ("urldecode".equals(function)) {
            return UrlUtil.decode(value);
        }
        if ("trim".equals(function)) {
            return StringUtils.trim((String)value);
        }
        if ("removeWhitespace".equals(function)) {
            return value.replaceAll(" ", "");
        }
        if ("removeHtml".equals(function)) {
            return SimpleMapping.removeHtml(value);
        }
        if ("removeUrls".equals(function)) {
            return SimpleMapping.removeUrls(value);
        }
        if ("toSolrDate".equals(function)) {
            return DateUtils.toSolrDate(value);
        }
        if ("uniq".equals(function)) {
            return value;
        }
        if ("removeSpecialChars".equals(function)) {
            value = value.replaceAll("[^a-zA-Z0-9']+", " ");
            return value;
        }
        if ("leftPad".equals(function)) {
            int size = Integer.valueOf(MapUtils.getOrDefault(this.config, "leftPad.size", "10"));
            String padChar = MapUtils.getOrDefault(this.config, "leftPad.padChar", "0");
            return StringUtils.leftPad((String)value, (int)size, (String)padChar);
        }
        throw new IllegalArgumentException("The function: " + function + " is not implemented.");
    }

    public static void executeFieldFunction(String function, Field field) {
        if ("md5".equals(function)) {
            return;
        }
        if ("base64Encode".equals(function)) {
            return;
        }
        if ("base64Decode".equals(function)) {
            return;
        }
        if ("mapGermanChars".equals(function)) {
            return;
        }
        if ("mapFranceChars".equals(function)) {
            return;
        }
        if ("lowercase".equals(function)) {
            return;
        }
        if ("urlencode".equals(function)) {
            return;
        }
        if ("urldecode".equals(function)) {
            return;
        }
        if ("trim".equals(function)) {
            return;
        }
        if ("removeWhitespace".equals(function)) {
            return;
        }
        if ("removeHtml".equals(function)) {
            return;
        }
        if ("removeUrls".equals(function)) {
            return;
        }
        if ("toSolrDate".equals(function)) {
            return;
        }
        if ("uniq".equals(function)) {
            HashSet<String> uniqValues = new HashSet<String>();
            uniqValues.addAll(field.getValues());
            field.setValues(new ArrayList<String>(uniqValues));
            return;
        }
        if ("removeSpecialChars".equals(function)) {
            return;
        }
        if ("leftPad".equals(function)) {
            return;
        }
        throw new IllegalArgumentException("The function: " + function + " is not implemented.");
    }

    public Map<String, List<String>> getMapping() {
        return this.mapping;
    }

    public Map<String, List<String>> getMappingFunctions() {
        return this.mappingFunctions;
    }

    public Map<String, String> getJoins() {
        return this.joins;
    }

    public static String mapGermanChars(String value) {
        value = value.replaceAll("\u00c4", "Ae");
        value = value.replaceAll("\u00d6", "Oe");
        value = value.replaceAll("\u00dc", "Ue");
        value = value.replaceAll("\u00e4", "ae");
        value = value.replaceAll("\u00f6", "oe");
        value = value.replaceAll("\u00fc", "ue");
        value = value.replaceAll("\u00df", "ss");
        return value;
    }

    public static String mapFranceChars(String value) {
        value = value.replaceAll("\u00c8", "E");
        value = value.replaceAll("\u00e8", "e");
        value = value.replaceAll("\u00c9", "E");
        value = value.replaceAll("\u00e9", "e");
        value = value.replaceAll("e\u0301", "e");
        value = value.replaceAll("\u00c0", "A");
        value = value.replaceAll("\u00e0", "a");
        value = value.replaceAll("\u00d9", "U");
        value = value.replaceAll("\u00f9", "u");
        value = value.replaceAll("\u00c2", "A");
        value = value.replaceAll("\u00e2", "a");
        value = value.replaceAll("\u00ca", "E");
        value = value.replaceAll("\u00ea", "e");
        value = value.replaceAll("\u00ce", "I");
        value = value.replaceAll("\u00ee", "i");
        value = value.replaceAll("\u00d4", "O");
        value = value.replaceAll("\u00f4", "o");
        value = value.replaceAll("\u00db", "U");
        value = value.replaceAll("\u00fb", "u");
        value = value.replaceAll("\u00c7", "C");
        value = value.replaceAll("\u00e7", "c");
        value = value.replaceAll("\u00cb", "E");
        value = value.replaceAll("\u00eb", "e");
        value = value.replaceAll("\u00cf", "I");
        value = value.replaceAll("\u00ee", "i");
        value = value.replaceAll("\u00dc", "U");
        value = value.replaceAll("\u00fb", "u");
        return value;
    }

    public static String removeHtml(String value) {
        Document jsoupDoc = Jsoup.parseBodyFragment((String)value);
        value = jsoupDoc.body().text();
        return value;
    }

    public static String removeUrls(String value) {
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            value = value.replaceAll("\\b(https?|ftp|file)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|]", " ");
        }
        return value;
    }
}

