/*
 * Decompiled with CFR 0.152.
 */
package de.tblsoft.solr.pipeline.filter;

import de.tblsoft.solr.pipeline.AbstractFilter;
import de.tblsoft.solr.pipeline.bean.Document;
import de.tblsoft.solr.pipeline.bean.Field;
import de.tblsoft.solr.pipeline.filter.BasicAuthConcurrentUpdateSolrClient;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.common.SolrInputDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrFeeder
extends AbstractFilter {
    private static Logger LOG = LoggerFactory.getLogger(SolrFeeder.class);
    private List<String> ignoreFields = new ArrayList<String>();
    private SolrClient server;
    private String serverUrl;
    private int queueSize = 1;
    private int threads = 1;
    private String user;
    private String password;
    boolean deleteIndex = false;

    @Override
    public void init() {
        this.queueSize = this.getPropertyAsInt("queueSize", 1);
        this.threads = this.getPropertyAsInt("threads", 1);
        this.serverUrl = this.getProperty("serverUrl", null);
        this.ignoreFields = this.getPropertyAsList("ignoreFields", null);
        this.deleteIndex = this.getPropertyAsBoolean("deleteIndex", false);
        this.user = this.getProperty("user", null);
        this.password = this.getProperty("password", null);
        if (this.serverUrl == null) {
            throw new RuntimeException("You must configure a solr server url.");
        }
        BasicAuthConcurrentUpdateSolrClient basicAuthserver = new BasicAuthConcurrentUpdateSolrClient(this.serverUrl, this.queueSize, this.threads);
        basicAuthserver.setBasicAuthCredentials(this.user, this.password);
        this.server = basicAuthserver;
        if (this.threads == 1 && this.queueSize == 1 && this.user == null) {
            this.server = new HttpSolrClient(this.serverUrl);
        }
        try {
            if (this.deleteIndex) {
                LOG.info("Delete the index.");
                this.server.deleteByQuery("*:*");
            }
        }
        catch (SolrServerException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void end() {
        try {
            this.server.commit();
            this.server.optimize();
            this.server.close();
        }
        catch (SolrServerException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void document(Document document) {
        SolrInputDocument inputDoc = new SolrInputDocument();
        for (Field field : document.getFields()) {
            if (this.isFieldIgnored(field.getName())) continue;
            inputDoc.addField(field.getName(), field.getValues());
        }
        try {
            this.server.add(inputDoc);
        }
        catch (SolrServerException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        super.document(document);
    }

    private boolean isFieldIgnored(String name) {
        if (this.ignoreFields == null) {
            return false;
        }
        for (String pattern : this.ignoreFields) {
            if (!name.matches(pattern)) continue;
            return true;
        }
        return false;
    }

    public void setIgnoreFields(List<String> ignoreFields) {
        this.ignoreFields = ignoreFields;
    }

    public void setQueueSize(int queueSize) {
        this.queueSize = queueSize;
    }

    public void setThreads(int threads) {
        this.threads = threads;
    }

    public void setDeleteIndex(boolean deleteIndex) {
        this.deleteIndex = deleteIndex;
    }
}

