/*
 * Decompiled with CFR 0.152.
 */
package de.tblsoft.solr.pipeline.filter;

import com.google.common.util.concurrent.AtomicLongMap;
import de.tblsoft.solr.pipeline.AbstractFilter;
import de.tblsoft.solr.pipeline.bean.Document;
import de.tblsoft.solr.pipeline.bean.Field;
import java.util.Map;

public class SolrFieldCounter
extends AbstractFilter {
    private AtomicLongMap<String> solrFields = AtomicLongMap.create();

    @Override
    public void document(Document document) {
        for (Field field : document.getFields()) {
            this.solrFields.incrementAndGet((Object)field.getName());
        }
    }

    @Override
    public void end() {
        Document document = new Document();
        Map fieldMap = this.solrFields.asMap();
        for (Map.Entry field : fieldMap.entrySet()) {
            document.addField((String)field.getKey(), String.valueOf(field.getValue()));
        }
        super.document(document);
        super.end();
    }
}

