/*
 * Decompiled with CFR 0.152.
 */
package de.tblsoft.solr.pipeline.filter;

import de.tblsoft.solr.http.HTTPHelper;
import de.tblsoft.solr.pipeline.AbstractFilter;
import de.tblsoft.solr.pipeline.bean.Document;
import de.tblsoft.solr.pipeline.bean.Field;
import de.tblsoft.solr.util.IOUtils;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import net.minidev.json.JSONValue;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.text.StrSubstitutor;

public class SplashFilter
extends AbstractFilter {
    private String splashPayloadFilename;
    private String splashPayload;
    private String splashUrl;
    private String jsSourceFilename;
    private String jsSource;
    private boolean shouldMatch = true;

    @Override
    public void init() {
        this.splashPayloadFilename = this.getProperty("splashPayloadFilename", null);
        this.splashUrl = this.getProperty("splashUrl", null);
        this.jsSourceFilename = this.getProperty("jsSourceFilename", null);
        try {
            String absoluteSplashPayloadFilename = IOUtils.getAbsoluteFile(this.getBaseDir(), this.splashPayloadFilename);
            this.splashPayload = FileUtils.readFileToString((File)new File(absoluteSplashPayloadFilename));
            String absoluteJsSourceFilename = IOUtils.getAbsoluteFile(this.getBaseDir(), this.jsSourceFilename);
            String jsSourceRaw = FileUtils.readFileToString((File)new File(absoluteJsSourceFilename));
            this.jsSource = JSONValue.escape((String)jsSourceRaw);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        super.init();
    }

    @Override
    public void document(Document document) {
        HashMap<String, String> documentMap = new HashMap<String, String>();
        for (Field field : document.getFields()) {
            documentMap.put(field.getName(), field.getValue());
        }
        StrSubstitutor sub = new StrSubstitutor(documentMap);
        String replacedJsSource = sub.replace(this.jsSource);
        documentMap.put("jsSource", replacedJsSource);
        String replacedSplashPayload = sub.replace(this.splashPayload);
        String response = HTTPHelper.post(this.splashUrl, replacedSplashPayload, "application/json");
        document.setField("splash_payload", response);
        super.document(document);
    }
}

