/*
 * Decompiled with CFR 0.152.
 */
package de.tblsoft.solr.pipeline.filter;

import com.google.common.base.Joiner;
import de.tblsoft.solr.pipeline.AbstractFilter;
import de.tblsoft.solr.pipeline.bean.Document;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpyFilter
extends AbstractFilter {
    private static Logger LOG = LoggerFactory.getLogger(SpyFilter.class);
    List<String> fields;

    @Override
    public void init() {
        this.fields = this.getPropertyAsList("fields", new ArrayList<String>());
        super.init();
    }

    @Override
    public void document(Document document) {
        for (String fieldName : this.fields) {
            List<String> values = document.getFieldValues(fieldName, new ArrayList<String>());
            String value = Joiner.on((String)"; ").join(values);
            LOG.info(fieldName + ": " + value);
        }
        super.document(document);
    }
}

