/*
 * Decompiled with CFR 0.152.
 */
package de.tblsoft.solr.pipeline.filter;

import de.tblsoft.solr.pipeline.AbstractFilter;
import de.tblsoft.solr.pipeline.bean.Document;
import de.tblsoft.solr.pipeline.bean.Field;
import de.tblsoft.solr.util.DatatypeUtils;
import de.tblsoft.solr.util.PairBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatisticFilter
extends AbstractFilter {
    private static Logger LOG = LoggerFactory.getLogger(StatisticFilter.class);
    private long documentCount = 0L;
    private Map<String, FieldStatistic> fieldStatisticMap = new HashMap<String, FieldStatistic>();
    private List<Pair<String, String>> dynamicFields = new ArrayList<Pair<String, String>>();

    @Override
    public void init() {
        super.init();
        this.initDynamicFields();
    }

    private void initDynamicFields() {
        List<String> dynamicFieldList = this.getPropertyAsList("dynamicFields", new ArrayList<String>());
        for (String value : dynamicFieldList) {
            this.dynamicFields.add(PairBuilder.createPair(value, "=>"));
        }
    }

    @Override
    public void document(Document document) {
        for (Field field : document.getFields()) {
            for (Pair<String, String> dynamicField : this.dynamicFields) {
                if (!field.getName().matches((String)dynamicField.getLeft())) continue;
                field.setName((String)dynamicField.getRight());
            }
            FieldStatistic fieldStatistic = this.fieldStatisticMap.get(field.getName());
            if (fieldStatistic == null) {
                fieldStatistic = new FieldStatistic(field.getName());
                this.fieldStatisticMap.put(field.getName(), fieldStatistic);
            }
            fieldStatistic.maxValueCount(field.getValues().size());
            for (String value : field.getValues()) {
                fieldStatistic.processValue(value);
            }
        }
        ++this.documentCount;
        super.document(document);
    }

    @Override
    public void end() {
        LOG.info("number of docs: " + this.documentCount);
        LOG.info("number of fields: " + this.fieldStatisticMap.size());
        LOG.info("");
        LOG.info("");
        System.out.printf("%40s %5s %5s %10s %100s", "field name", "mv", "count", "type", "example values");
        LOG.info("");
        try {
            for (Map.Entry<String, FieldStatistic> fieldStatisticEntry : this.fieldStatisticMap.entrySet()) {
                FieldStatistic fieldStatistic = fieldStatisticEntry.getValue();
                StringBuilder exampleValueBuilder = new StringBuilder();
                for (String value : fieldStatistic.getExampleValues()) {
                    exampleValueBuilder.append(StringUtils.abbreviate((String)value, (int)20)).append(", ");
                }
                System.out.printf("%40s %5s %5s %10s %100s", fieldStatistic.getFieldName(), fieldStatistic.isMultiValue(), fieldStatistic.getMaxValueCount(), fieldStatistic.getDataType(), exampleValueBuilder.toString());
                LOG.info("");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        super.end();
    }

    class FieldStatistic {
        private String fieldName;
        private Set<String> exampleValues = new HashSet<String>();
        private String min;
        private String max;
        private String minLength;
        private String maxLength;
        private int maxValueCount = 0;
        private String dataType;

        public FieldStatistic(String fieldName) {
            this.fieldName = fieldName;
        }

        public void processValue(String value) {
            this.min(value);
            this.max(value);
            this.dataType(value);
            this.exampleValue(value);
        }

        public void exampleValue(String value) {
            this.exampleValues.add(value);
            if (this.exampleValues.size() > 5) {
                String valueToRemove = this.exampleValues.iterator().next();
                this.exampleValues.remove(valueToRemove);
            }
        }

        public void dataType(String value) {
            if (StringUtils.isEmpty((CharSequence)value)) {
                return;
            }
            String currentDatatype = DatatypeUtils.estimateDatatype(value);
            if (this.dataType == null) {
                this.dataType = currentDatatype;
                return;
            }
            this.dataType = DatatypeUtils.getBestDatatype(currentDatatype, this.dataType);
        }

        public void min(String min) {
            if (min == null) {
                return;
            }
            if (this.min == null) {
                this.min = min;
                return;
            }
            if (this.min.compareTo(min) < 1) {
                this.min = min;
            }
        }

        public void max(String max) {
            if (max == null) {
                return;
            }
            if (this.max == null) {
                this.max = max;
                return;
            }
            if (this.max.compareTo(max) > 1) {
                this.max = max;
            }
        }

        public void maxValueCount(int valueCount) {
            if (valueCount > this.maxValueCount) {
                this.maxValueCount = valueCount;
            }
        }

        public boolean isMultiValue() {
            return this.maxValueCount > 1;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }

        public Set<String> getExampleValues() {
            return this.exampleValues;
        }

        public void setExampleValues(Set<String> exampleValues) {
            this.exampleValues = exampleValues;
        }

        public String getMin() {
            return this.min;
        }

        public void setMin(String min) {
            this.min = min;
        }

        public String getMax() {
            return this.max;
        }

        public void setMax(String max) {
            this.max = max;
        }

        public String getMinLength() {
            return this.minLength;
        }

        public void setMinLength(String minLength) {
            this.minLength = minLength;
        }

        public String getMaxLength() {
            return this.maxLength;
        }

        public void setMaxLength(String maxLength) {
            this.maxLength = maxLength;
        }

        public int getMaxValueCount() {
            return this.maxValueCount;
        }

        public void setMaxValueCount(int maxValueCount) {
            this.maxValueCount = maxValueCount;
        }

        public String getDataType() {
            return this.dataType;
        }

        public void setDataType(String dataType) {
            this.dataType = dataType;
        }
    }
}

