/*
 * Decompiled with CFR 0.152.
 */
package de.tblsoft.solr.pipeline.filter;

import de.tblsoft.solr.pipeline.AbstractFilter;
import de.tblsoft.solr.pipeline.bean.Document;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.List;
import java.util.regex.Pattern;

public class StopwordFilter
extends AbstractFilter {
    private List<String> fields;
    private String replacement;
    private Pattern regex;
    private List<String> stopwords;

    @Override
    public void init() {
        this.fields = this.getPropertyAsList("fields", null);
        this.verify(this.fields, "For the RegexSplitFilter a fields property must be defined!");
        this.replacement = this.getProperty("replacement", " ");
        String filepath = this.getProperty("filepath", null);
        this.verify(filepath, "For the StopwordFilter a filepath property must be defined!");
        try {
            this.stopwords = Files.readAllLines(new File(filepath).toPath(), Charset.forName("UTF-8"));
        }
        catch (IOException e) {
            throw new RuntimeException("Could not read stopword file!", e);
        }
        StringBuilder regexBuilder = new StringBuilder("\\b(");
        for (int i = 0; i < this.stopwords.size(); ++i) {
            String stopword = this.stopwords.get(i);
            regexBuilder.append(stopword);
            if (i + 1 >= this.stopwords.size()) continue;
            regexBuilder.append("|");
        }
        regexBuilder.append(")\\b");
        this.regex = Pattern.compile(regexBuilder.toString());
        super.init();
    }

    @Override
    public void document(Document document) {
        for (String field : this.fields) {
            List<String> fieldValues = document.getFieldValues(field);
            if (fieldValues == null) continue;
            for (int i = 0; i < fieldValues.size(); ++i) {
                String value = fieldValues.get(i);
                value = value.replaceAll(this.regex.pattern(), this.replacement);
                fieldValues.set(i, value);
            }
        }
        super.document(document);
    }
}

