/*
 * Decompiled with CFR 0.152.
 */
package de.tblsoft.solr.pipeline.filter;

import de.tblsoft.solr.pipeline.AbstractFilter;
import de.tblsoft.solr.pipeline.bean.Document;
import de.tblsoft.solr.util.IOUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SynonymNormalizationFilter
extends AbstractFilter {
    private static Logger LOG = LoggerFactory.getLogger(SynonymNormalizationFilter.class);
    Map<String, String> synonymLookup;
    Set<String> mainWordLookup;
    String fieldSynonym;
    String arrayDelimiter;
    Boolean mustExist;

    @Override
    public void init() {
        this.fieldSynonym = this.getProperty("fieldSynonym", null);
        this.arrayDelimiter = this.getProperty("arrayDelimiter", ";");
        this.mustExist = this.getPropertyAsBoolean("mustExist", false);
        this.synonymLookup = new HashMap<String, String>();
        this.mainWordLookup = new HashSet<String>();
        InputStream in = null;
        try {
            String filename = this.getProperty("filename", null);
            String absoluteFilename = IOUtils.getAbsoluteFile(this.getBaseDir(), filename);
            in = IOUtils.getInputStream(absoluteFilename);
            InputStreamReader reader = new InputStreamReader(in, StandardCharsets.UTF_8.name());
            CSVFormat format = CSVFormat.RFC4180.withDelimiter(',');
            CSVParser parser = format.parse((Reader)reader);
            for (CSVRecord record : parser) {
                try {
                    String mainWord = record.get(0);
                    String[] synonyms = record.get(1).split(this.arrayDelimiter);
                    if (synonyms != null && synonyms.length > 0) {
                        for (String synonym : synonyms) {
                            if (!StringUtils.isNotEmpty((CharSequence)synonym)) continue;
                            this.synonymLookup.put(synonym, mainWord);
                        }
                    }
                    this.mainWordLookup.add(mainWord);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        super.init();
    }

    @Override
    public void document(Document document) {
        boolean exist = false;
        List<String> words = document.getFieldValues(this.fieldSynonym);
        if (words != null && words.size() > 0) {
            for (int i = 0; i < words.size(); ++i) {
                String word = words.get(i);
                if (this.synonymLookup.containsKey(word)) {
                    word = this.synonymLookup.get(word);
                    words.set(i, word);
                    exist = true;
                    continue;
                }
                if (this.mainWordLookup.contains(word)) {
                    exist = true;
                    continue;
                }
                if (!this.mustExist.booleanValue()) continue;
                LOG.info("SynonymNormalizationFilter: Omit non existing word -> " + word);
            }
        } else {
            exist = true;
        }
        if (!this.mustExist.booleanValue() || exist) {
            super.document(document);
        }
    }
}

