/*
 * Decompiled with CFR 0.152.
 */
package de.tblsoft.solr.pipeline.filter;

import com.google.common.base.Joiner;
import de.tblsoft.solr.pipeline.AbstractFilter;
import de.tblsoft.solr.pipeline.bean.Document;
import de.tblsoft.solr.pipeline.bean.Field;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemOutWriter
extends AbstractFilter {
    private static Logger LOG = LoggerFactory.getLogger(SystemOutWriter.class);
    private String prefix;
    private int fieldCounter = 0;
    private int documentCounter = 0;

    @Override
    public void init() {
        try {
            this.prefix = this.getProperty("prefix", "");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        super.init();
    }

    @Override
    public void document(Document document) {
        ++this.documentCounter;
        List<Field> values = document.getFields();
        if (values != null) {
            for (Field f : values) {
                ++this.fieldCounter;
                LOG.info(this.prefix + "name: " + f.getName());
                String out = f.getValues() != null ? Joiner.on((String)", ").skipNulls().join(f.getValues()) : null;
                LOG.info(this.prefix + " -- value: " + out);
            }
        }
        super.document(document);
    }

    @Override
    public void end() {
        LOG.info("end");
        LOG.info("fields: " + this.fieldCounter);
        LOG.info("documents: " + this.documentCounter);
        super.end();
    }
}

