/*
 * Decompiled with CFR 0.152.
 */
package de.tblsoft.solr.pipeline.filter;

import de.tblsoft.solr.pipeline.AbstractFilter;
import de.tblsoft.solr.pipeline.bean.Document;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class TokenCounterFilter
extends AbstractFilter {
    private String fieldName;
    private String tokenCountFieldName;

    @Override
    public void init() {
        this.fieldName = this.getProperty("fieldName", null);
        this.verify(this.fieldName, "For the TokenCounterFilter a fieldName property must be defined.");
        this.tokenCountFieldName = this.getProperty("tokenCountFieldName", "tokenCount");
        super.init();
    }

    @Override
    public void document(Document document) {
        List<String> values = document.getFieldValues(this.fieldName, new ArrayList<String>());
        int tokenCount = 0;
        for (String value : values) {
            StringTokenizer tokenizer = new StringTokenizer(value);
            tokenCount += tokenizer.countTokens();
        }
        document.setField(this.tokenCountFieldName, String.valueOf(tokenCount));
        super.document(document);
    }
}

