/*
 * Decompiled with CFR 0.152.
 */
package de.tblsoft.solr.pipeline.filter;

import de.tblsoft.solr.pipeline.AbstractFilter;
import de.tblsoft.solr.pipeline.bean.Document;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.commons.lang3.StringUtils;

public class TokenPermutationFilter
extends AbstractFilter {
    private List<String> fields;
    private int minTokens;
    private int maxTokens;
    private int poolSize;
    List<Document> previousDocs;

    @Override
    public void init() {
        this.poolSize = this.getPropertyAsInt("poolSize", 100);
        this.minTokens = this.getPropertyAsInt("minTokens", 1);
        this.maxTokens = this.getPropertyAsInt("maxTokens", 10);
        this.fields = this.getPropertyAsList("fields", null);
        this.verify(this.fields, "For the PermutationFilter fields must be defined!");
        this.previousDocs = new ArrayList<Document>();
        super.init();
    }

    @Override
    public void document(Document doc) {
        Document permutedDoc = TokenPermutationFilter.permuteDocument(doc, this.previousDocs, this.fields, this.minTokens, this.maxTokens);
        super.document(permutedDoc);
        this.previousDocs.add(doc);
        if (this.previousDocs.size() > this.poolSize) {
            this.previousDocs.remove(0);
        }
    }

    protected static Document permuteDocument(Document currentDoc, List<Document> previousDocs, List<String> fields, int minTokens, int maxTokens) {
        Document result = new Document(currentDoc);
        if (previousDocs.size() > 0) {
            for (String field : fields) {
                int tokenSize = new Random().nextInt(maxTokens - minTokens) + minTokens;
                String permutedValue = TokenPermutationFilter.permuteFieldValue(field, previousDocs, tokenSize);
                result.setField(field, permutedValue);
            }
        }
        return result;
    }

    protected static String permuteFieldValue(String field, List<Document> previousDocs, int tokenSize) {
        ArrayList<String> tokens = new ArrayList<String>();
        while (tokens.size() < tokenSize) {
            int randDoc = new Random().nextInt(previousDocs.size());
            Document previousDoc = previousDocs.get(randDoc);
            String fieldValue = previousDoc.getFieldValue(field);
            String randomToken = TokenPermutationFilter.getRandomToken(fieldValue);
            if (randomToken == null) continue;
            tokens.add(randomToken);
        }
        String result = StringUtils.join(tokens, (String)" ");
        return result;
    }

    protected static String getRandomToken(String text) {
        String token = "";
        if (StringUtils.isNotEmpty((CharSequence)text)) {
            String[] tokens = text.split("\\s+");
            int i = new Random().nextInt(tokens.length);
            token = tokens[i];
        }
        return token;
    }
}

