/*
 * Decompiled with CFR 0.152.
 */
package de.tblsoft.solr.pipeline.filter;

import de.tblsoft.solr.pipeline.AbstractFilter;
import de.tblsoft.solr.pipeline.bean.Document;
import de.tblsoft.solr.pipeline.bean.Field;
import java.util.StringTokenizer;

public class TokenizerFilter
extends AbstractFilter {
    private String delim;

    @Override
    public void init() {
        this.delim = this.getProperty("delim", " \t\n\r\f");
        super.init();
    }

    @Override
    public void document(Document document) {
        for (Field field : document.getFields()) {
            for (String value : field.getValues()) {
                StringTokenizer tokenizer = new StringTokenizer(value, this.delim);
                while (tokenizer.hasMoreElements()) {
                    String token = tokenizer.nextToken();
                    Document newDocument = new Document();
                    newDocument.addField("token", token);
                    super.document(newDocument);
                }
            }
        }
    }
}

