/*
 * Decompiled with CFR 0.152.
 */
package de.tblsoft.solr.pipeline.filter;

import de.tblsoft.solr.pipeline.AbstractFilter;
import de.tblsoft.solr.pipeline.bean.Document;
import de.tblsoft.solr.pipeline.bean.Field;
import de.tblsoft.solr.util.DocumentUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class TopicAggregationFilter
extends AbstractFilter {
    private List<AggregationId> idFields = new ArrayList<AggregationId>();
    private String fieldTopic;
    private String fieldValue;
    private Map<String, Document> docs = new HashMap<String, Document>();

    @Override
    public void init() {
        List<String> ids = this.getPropertyAsList("idField", null);
        this.verify(ids, "For the TopicAggregationFilter a idField property must be defined!");
        for (String field : ids) {
            String[] fields = field.split(",");
            AggregationId aggregationId = new AggregationId(Arrays.asList(fields));
            this.idFields.add(aggregationId);
        }
        this.fieldTopic = this.getProperty("fieldTopic", null);
        this.fieldValue = this.getProperty("fieldValue", null);
        super.init();
    }

    @Override
    public void document(Document document) {
        for (AggregationId idField : this.idFields) {
            String docId = idField.buildId(document);
            if (docId == null) continue;
            this.putTopicValueAsField(document);
            if (!this.docs.containsKey(docId)) {
                this.docs.put(docId, document);
                break;
            }
            Document oldDoc = this.docs.get(docId);
            Document mergedDoc = this.mergeDocuments(oldDoc, document);
            this.docs.put(docId, mergedDoc);
            break;
        }
    }

    @Override
    public void end() {
        for (Map.Entry<String, Document> entry : this.docs.entrySet()) {
            Document doc = entry.getValue();
            super.document(doc);
        }
        super.end();
    }

    protected Document mergeDocuments(Document doc1, Document doc2) {
        HashMap mergedFields = new HashMap();
        for (Field field : doc1.getFields()) {
            mergedFields.put(field.getName(), new HashSet<String>(field.getValues()));
        }
        for (Field field : doc2.getFields()) {
            if (!mergedFields.containsKey(field.getName())) {
                mergedFields.put(field.getName(), new HashSet());
            }
            ((HashSet)mergedFields.get(field.getName())).addAll(field.getValues());
        }
        Document mergedDoc = new Document();
        for (Map.Entry entry : mergedFields.entrySet()) {
            Field mergedField = new Field((String)entry.getKey(), new ArrayList<String>((Collection)entry.getValue()));
            mergedDoc.addField(mergedField);
        }
        return mergedDoc;
    }

    protected void putTopicValueAsField(Document document) {
        Map<String, Field> fieldMap = DocumentUtils.mapFields(document);
        if (fieldMap.containsKey(this.fieldTopic) && fieldMap.containsKey(this.fieldValue)) {
            Field topicField = fieldMap.get(this.fieldTopic);
            Field valueField = fieldMap.get(this.fieldValue);
            document.setField(topicField.getValue(), valueField.getValues());
            document.deleteField(this.fieldTopic);
            document.deleteField(this.fieldValue);
        }
    }

    public class AggregationId {
        List<String> fields = new ArrayList<String>();

        public AggregationId(List<String> fields) {
            this.fields = fields;
        }

        public String buildId(Document document) {
            String field;
            String fieldValue;
            String id = "";
            Iterator<String> iterator = this.fields.iterator();
            while (iterator.hasNext() && !StringUtils.isEmpty((CharSequence)(fieldValue = document.getFieldValue(field = iterator.next())))) {
                id = id + "." + fieldValue;
            }
            if (StringUtils.isEmpty((CharSequence)id)) {
                id = null;
            }
            return id;
        }
    }
}

