/*
 * Decompiled with CFR 0.152.
 */
package de.tblsoft.solr.pipeline.filter;

import de.tblsoft.solr.pipeline.AbstractFilter;
import de.tblsoft.solr.pipeline.bean.Document;
import de.tblsoft.solr.pipeline.bean.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class TopicMergeFilter
extends AbstractFilter {
    private String fieldTopic;
    private String fieldValue;
    private boolean fieldValueLowercase;
    private Map<String, Map<String, Document>> topicValues = new HashMap<String, Map<String, Document>>();

    @Override
    public void init() {
        this.fieldTopic = this.getProperty("fieldTopic", null);
        this.fieldValue = this.getProperty("fieldValue", null);
        this.fieldValueLowercase = this.getPropertyAsBoolean("fieldValueLowercase", true);
        this.verify(this.fieldValue, "For the TopicUniqueFilter a fieldTopic property must be defined.");
        this.verify(this.fieldValue, "For the TopicUniqueFilter a fieldValue property must be defined.");
        super.init();
    }

    @Override
    public void document(Document document) {
        String topic = document.getFieldValue(this.fieldTopic);
        String value = document.getFieldValue(this.fieldValue);
        if (this.fieldValueLowercase) {
            value = value.toLowerCase();
        }
        if (!this.topicValues.containsKey(topic)) {
            this.topicValues.put(topic, new HashMap());
        }
        if (!this.topicValues.get(topic).containsKey(value)) {
            this.topicValues.get(topic).put(value, document);
        } else {
            Document oldDoc = this.topicValues.get(topic).get(value);
            Document mergedDoc = this.mergeDocuments(oldDoc, document);
            this.topicValues.get(topic).put(value, mergedDoc);
        }
    }

    protected Document mergeDocuments(Document doc1, Document doc2) {
        HashMap<String, HashSet<String>> mergedFields = new HashMap<String, HashSet<String>>();
        for (Field field : doc1.getFields()) {
            if (field.getValues() == null) continue;
            mergedFields.put(field.getName(), new HashSet<String>(field.getValues()));
        }
        for (Field field : doc2.getFields()) {
            if (!mergedFields.containsKey(field.getName()) || field.getValues() == null) continue;
            ((HashSet)mergedFields.get(field.getName())).addAll(field.getValues());
        }
        Document mergedDoc = new Document();
        for (Map.Entry entry : mergedFields.entrySet()) {
            Field mergedField = new Field((String)entry.getKey(), new ArrayList<String>((Collection)entry.getValue()));
            mergedDoc.addField(mergedField);
        }
        return mergedDoc;
    }

    @Override
    public void end() {
        for (Map<String, Document> topicValueDocs : this.topicValues.values()) {
            for (Document doc : topicValueDocs.values()) {
                super.document(doc);
            }
        }
        super.end();
    }
}

