/*
 * Decompiled with CFR 0.152.
 */
package de.tblsoft.solr.pipeline.filter;

import com.google.common.base.Strings;
import de.tblsoft.solr.http.UrlUtil;
import de.tblsoft.solr.pipeline.AbstractFilter;
import de.tblsoft.solr.pipeline.bean.Document;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.NameValuePair;

public class UrlSplitter
extends AbstractFilter {
    private String urlField;
    private String fieldPrefix;

    @Override
    public void init() {
        this.urlField = this.getProperty("urlField", "url");
        this.fieldPrefix = this.getProperty("fieldPrefix", "");
        super.init();
    }

    @Override
    public void document(Document document) {
        String value = document.getFieldValue(this.urlField, "");
        if (value.startsWith("http")) {
            List<NameValuePair> urlParams = UrlUtil.getUrlParams(value);
            for (NameValuePair urlParam : urlParams) {
                document.addField(this.fieldPrefix + urlParam.getName(), urlParam.getValue());
            }
            String path = UrlUtil.getPath(value);
            document.addField(this.fieldPrefix + "_path", path);
            String[] pathSplitted = path.split(Pattern.quote("/"));
            StringBuilder pathParts = new StringBuilder();
            for (int i = 0; i < pathSplitted.length; ++i) {
                String pathPart = pathSplitted[i];
                if (StringUtils.isEmpty((CharSequence)pathPart)) continue;
                document.addField(this.fieldPrefix + "_path_" + i, pathPart);
                document.addField(this.fieldPrefix + "_pathall", pathPart);
                pathParts.append("/").append(pathPart);
                document.addField(this.fieldPrefix + "_pathallparts", pathParts.toString());
            }
            document.addField(this.fieldPrefix + "_pathcount", String.valueOf(pathSplitted.length));
            String host = UrlUtil.getHost(value);
            document.addField(this.fieldPrefix + "_host", host);
            String protocol = UrlUtil.getProtocol(value);
            document.addField(this.fieldPrefix + "_protocol", protocol);
            document.addField(this.fieldPrefix + "_query", UrlUtil.getUrlQuery(value));
        } else {
            if (value.contains("?")) {
                throw new UnsupportedOperationException("The url is not correct " + value);
            }
            if (!Strings.isNullOrEmpty((String)value)) {
                throw new UnsupportedOperationException("The url is not correct " + value);
            }
        }
        super.document(document);
    }
}

