/*
 * Decompiled with CFR 0.152.
 */
package de.tblsoft.solr.pipeline.filter;

import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import de.tblsoft.solr.pipeline.AbstractFilter;
import de.tblsoft.solr.pipeline.bean.Document;
import java.util.ArrayList;
import java.util.List;

public class ValidationFilter
extends AbstractFilter {
    private String validationField;
    private List<String> requiredFields = new ArrayList<String>();

    @Override
    public void init() {
        this.validationField = this.getProperty("validationField", "validation");
        this.requiredFields = this.getPropertyAsList("requiredFields", new ArrayList<String>());
        super.init();
    }

    @Override
    public void document(Document document) {
        this.checkRequiredFields(document);
        super.document(document);
    }

    void checkRequiredFields(Document document) {
        for (String requiredField : this.requiredFields) {
            List<String> values = document.getFieldValues(requiredField);
            if (this.validateRequiredField(values)) continue;
            document.addField(this.validationField, requiredField + "_missingRequired");
        }
    }

    boolean validateRequiredField(List<String> values) {
        if (values == null || values.isEmpty()) {
            return false;
        }
        String value = (String)Iterables.getFirst(values, null);
        return !Strings.isNullOrEmpty((String)value);
    }
}

