/*
 * Decompiled with CFR 0.152.
 */
package de.tblsoft.solr.pipeline.filter;

import de.tblsoft.solr.pipeline.AbstractFilter;
import de.tblsoft.solr.pipeline.bean.Document;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ValueMappingFilter
extends AbstractFilter {
    private Map<String, String> mapping = new HashMap<String, String>();
    private String fieldName;
    private Boolean passUndefinedValues = Boolean.TRUE;

    @Override
    public void init() {
        this.fieldName = this.getProperty("fieldName", null);
        this.passUndefinedValues = this.getPropertyAsBoolean("passUndefinedValues", Boolean.TRUE);
        this.verify("fieldName", "The field fieldName must be configured.");
        this.mapping = this.getPropertyAsMapping("mapping");
        super.init();
    }

    @Override
    public void document(Document document) {
        List<String> values = document.getFieldValues(this.fieldName);
        if (values == null) {
            super.document(document);
            return;
        }
        ArrayList<String> mappedValues = new ArrayList<String>();
        for (String value : values) {
            String mappedValue = this.mapping.get(value);
            if (mappedValue == null && this.passUndefinedValues.booleanValue()) {
                mappedValues.add(value);
                continue;
            }
            mappedValues.add(mappedValue);
        }
        document.setField(this.fieldName, (List<String>)mappedValues);
        super.document(document);
    }
}

