/*
 * Decompiled with CFR 0.152.
 */
package de.tblsoft.solr.pipeline.filter;

import de.tblsoft.solr.pipeline.AbstractFilter;
import de.tblsoft.solr.pipeline.bean.Document;
import de.tblsoft.solr.pipeline.bean.Field;
import de.tblsoft.solr.util.IOUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;

public class WhitelistTopicTermsFilter
extends AbstractFilter {
    Map<String, HashMap<String, Document>> topicValues;
    Map<String, HashMap<String, Boolean>> topicsOverriden;
    String fieldTopic;
    String fieldValue;
    boolean override;
    String arrayDelimiter;

    @Override
    public void init() {
        this.fieldTopic = this.getProperty("fieldTopic", null);
        this.fieldValue = this.getProperty("fieldValue", null);
        this.override = this.getPropertyAsBoolean("override", true);
        this.arrayDelimiter = this.getProperty("arrayDelimiter", ";");
        this.topicValues = new HashMap<String, HashMap<String, Document>>();
        this.topicsOverriden = new HashMap<String, HashMap<String, Boolean>>();
        InputStream in = null;
        try {
            String filename = this.getProperty("filename", null);
            String absoluteFilename = IOUtils.getAbsoluteFile(this.getBaseDir(), filename);
            in = IOUtils.getInputStream(absoluteFilename);
            InputStreamReader reader = new InputStreamReader(in, StandardCharsets.UTF_8.name());
            CSVFormat format = CSVFormat.RFC4180.withHeader(new String[0]).withDelimiter(',');
            CSVParser parser = format.parse((Reader)reader);
            for (CSVRecord record : parser) {
                Map header = parser.getHeaderMap();
                Document document = new Document();
                for (Map.Entry entry : header.entrySet()) {
                    String key = (String)entry.getKey();
                    try {
                        String[] values = record.get(key).split(this.arrayDelimiter);
                        document.addField(key, Arrays.asList(values));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                }
                String topic = record.get(((Integer)header.get(this.fieldTopic)).intValue());
                String value = record.get(((Integer)header.get(this.fieldValue)).intValue());
                if (!this.topicValues.containsKey(topic)) {
                    this.topicValues.put(topic, new HashMap());
                    this.topicsOverriden.put(topic, new HashMap());
                }
                this.topicValues.get(topic).put(value, document);
                this.topicsOverriden.get(topic).put(value, false);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        super.init();
    }

    @Override
    public void document(Document document) {
        Field topic = document.getField(this.fieldTopic);
        Field value = document.getField(this.fieldValue);
        boolean hasOverriden = false;
        if (this.override && topic != null && value != null && this.topicValues.containsKey(topic.getValue()) && this.topicValues.get(topic.getValue()).containsKey(value.getValue())) {
            Document docOverride = this.topicValues.get(topic.getValue()).get(value.getValue());
            for (Field field : docOverride.getFields()) {
                document.setField(field.getName(), field.getValues());
            }
            super.document(document);
            hasOverriden = true;
            this.topicsOverriden.get(topic.getValue()).put(value.getValue(), true);
        }
        if (!hasOverriden) {
            super.document(document);
        }
    }

    @Override
    public void end() {
        for (Map.Entry<String, HashMap<String, Document>> entry : this.topicValues.entrySet()) {
            String topic = entry.getKey();
            for (Map.Entry<String, Document> valueEntry : entry.getValue().entrySet()) {
                String value = valueEntry.getKey();
                Boolean overridden = this.topicsOverriden.get(topic).get(value);
                if (overridden.booleanValue()) continue;
                super.document(valueEntry.getValue());
            }
        }
        super.end();
    }
}

