/*
 * Decompiled with CFR 0.152.
 */
package de.tblsoft.solr.pipeline.filter;

import de.tblsoft.solr.pipeline.AbstractFilter;
import de.tblsoft.solr.pipeline.bean.Document;
import de.tblsoft.solr.sitemap.bean.Sitemap;
import de.tblsoft.solr.sitemap.bean.Sitemapindex;
import de.tblsoft.solr.util.DateUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class XmlSitemapWriter
extends AbstractFilter {
    private XMLStreamWriter writer;
    private Integer maxEntriesPerFile;
    private long documentCounter = 0L;
    private long sitemapCounter = 0L;
    private String filename;
    private String sitemapIndexFilename;
    private String baseUrl;
    private List<String> sitemapFiles = new ArrayList<String>();

    @Override
    public void init() {
        try {
            this.filename = this.getProperty("filename", null);
            this.sitemapIndexFilename = this.getProperty("sitemapIndexFilename", "sitemap-index.xml");
            this.baseUrl = this.getProperty("baseUrl", null);
            this.maxEntriesPerFile = this.getPropertyAsInt("maxEntriesPerFile", 50000);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        super.init();
    }

    @Override
    public void document(Document document) {
        if (this.documentCounter % (long)this.maxEntriesPerFile.intValue() == 0L) {
            this.finishSitemapFile();
            this.createNewSitemapFile();
            ++this.sitemapCounter;
        }
        try {
            this.writer.writeStartElement("url");
            this.writeField("loc", document, null);
            this.writeField("lastmod", document, DateUtils.date2String(new Date()));
            this.writeField("changefreq", document, "daily");
            this.writeField("priority", document, "0.7");
            this.writer.writeEndElement();
            ++this.documentCounter;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        super.document(document);
    }

    private void finishSitemapFile() {
        if (this.writer == null) {
            return;
        }
        try {
            this.writer.writeEndElement();
            this.writer.flush();
            this.writer.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void createNewSitemapFile() {
        try {
            XMLOutputFactory output = XMLOutputFactory.newInstance();
            String finalFilename = this.filename.replaceAll(Pattern.quote("${sitemapCounter}"), String.valueOf(this.sitemapCounter));
            this.sitemapFiles.add(finalFilename);
            File file = new File(finalFilename);
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            FileOutputStream os = new FileOutputStream(file);
            this.writer = output.createXMLStreamWriter(os);
            this.writer.writeStartDocument();
            this.writer.writeStartElement("urlset");
            this.writer.writeDefaultNamespace("http://www.sitemaps.org/schemas/sitemap/0.9");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void writeField(String name, Document document, String defaultValue) throws XMLStreamException {
        String value = document.getFieldValue(name);
        if (value == null) {
            value = defaultValue;
        }
        this.writer.writeStartElement(name);
        this.writer.writeCharacters(value);
        this.writer.writeEndElement();
    }

    @Override
    public void end() {
        this.finishSitemapFile();
        this.createSitemapIndex();
        super.end();
    }

    private void createSitemapIndex() {
        try {
            Sitemapindex sitemapindex = new Sitemapindex();
            for (String sitemapFile : this.sitemapFiles) {
                Sitemap sitemap = new Sitemap();
                File file = new File(sitemapFile);
                sitemap.setLoc(this.baseUrl + file.getName());
                sitemapindex.getSitemap().add(sitemap);
            }
            File file = new File(this.sitemapIndexFilename);
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Sitemapindex.class});
            Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
            jaxbMarshaller.setProperty("jaxb.formatted.output", (Object)true);
            jaxbMarshaller.marshal((Object)sitemapindex, file);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

