/*
 * Decompiled with CFR 0.152.
 */
package de.tblsoft.solr.pipeline.nlp.squad;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.tblsoft.solr.pipeline.AbstractReader;
import de.tblsoft.solr.pipeline.PipelineExecuter;
import de.tblsoft.solr.pipeline.bean.Document;
import de.tblsoft.solr.pipeline.bean.Reader;
import de.tblsoft.solr.pipeline.nlp.squad.dto.Data;
import de.tblsoft.solr.pipeline.nlp.squad.dto.Squad;
import de.tblsoft.solr.util.IOUtils;
import java.io.InputStream;

public class SquadReader
extends AbstractReader {
    @Override
    public void read() {
        try {
            String filename = this.getProperty("filename", null);
            String absoluteFilename = IOUtils.getAbsoluteFile(this.getBaseDir(), filename);
            InputStream in = IOUtils.getInputStream(absoluteFilename);
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            Squad squad = (Squad)objectMapper.readValue(in, Squad.class);
            in.close();
            for (Data data : squad.getData()) {
                Document document = new Document();
                document.setRawField("data", data, "json");
                this.executer.document(document);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setPipelineExecuter(PipelineExecuter executer) {
        this.executer = executer;
    }

    @Override
    public void end() {
    }

    @Override
    public void setReader(Reader reader) {
        this.reader = reader;
    }
}

