/*
 * Decompiled with CFR 0.152.
 */
package de.tblsoft.solr.pipeline.nlp.squad;

import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import de.tblsoft.solr.pipeline.nlp.squad.AbstractSquadFilter;
import de.tblsoft.solr.pipeline.nlp.squad.dto.Data;
import de.tblsoft.solr.pipeline.nlp.squad.dto.Squad;
import de.tblsoft.solr.util.IOUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

public class SquadWriter
extends AbstractSquadFilter {
    private String absoluteFilename;
    private Squad squad;

    @Override
    public void init() {
        try {
            String filename = this.getProperty("filename", null);
            String squadVersion = this.getProperty("squadVersion", "v2.0");
            this.absoluteFilename = IOUtils.getAbsoluteFile(this.getBaseDir(), filename);
            this.squad = new Squad();
            this.squad.setData(new ArrayList<Data>());
            this.squad.setVersion(squadVersion);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        super.init();
    }

    @Override
    public Data data(Data data) {
        this.squad.getData().add(data);
        return data;
    }

    @Override
    public void end() {
        ObjectMapper objectMapper = new ObjectMapper();
        ObjectWriter writer = objectMapper.writer((PrettyPrinter)new DefaultPrettyPrinter());
        try {
            writer.writeValue(new File(this.absoluteFilename), (Object)this.squad);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not serialize sqad file: " + this.absoluteFilename, e);
        }
    }
}

