/*
 * Decompiled with CFR 0.152.
 */
package de.tblsoft.solr.pipeline.processor;

import de.tblsoft.solr.pipeline.processor.LineProcessor;
import org.apache.commons.lang3.StringUtils;

public class CountCharInLineProcessor
extends LineProcessor {
    private String charToCount;
    private Long charCount;

    @Override
    public void init() {
        super.init();
        this.charToCount = this.getProperty("charToCount", null);
        this.charCount = this.getPropertyAsInteger("charCount", null);
    }

    @Override
    public String processLine(String line) {
        if (this.getCurrentLine() <= this.getSkipLines()) {
            return line;
        }
        int currentCount = StringUtils.countMatches((CharSequence)line, (CharSequence)this.charToCount);
        if ((long)currentCount == this.charCount) {
            return line;
        }
        return null;
    }
}

