/*
 * Decompiled with CFR 0.152.
 */
package de.tblsoft.solr.pipeline.processor;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import de.tblsoft.solr.pipeline.AbstractProcessor;
import de.tblsoft.solr.util.IOUtils;
import java.io.File;
import java.util.List;
import java.util.UUID;
import org.apache.commons.io.FileUtils;

public class Json2SingleDocumentsProcessor
extends AbstractProcessor {
    @Override
    public void process() {
        try {
            List<String> filenames = this.getPropertyAsList("filenames", null);
            String idSelector = this.getProperty("idSelector", null);
            String documentSelector = this.getProperty("documentSelector", "$");
            String outputPrefix = this.getProperty("outputPrefix", "output/debug_");
            String fileExtension = this.getProperty("fileExtension", ".json");
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            for (String filename : filenames) {
                File jsonFile = IOUtils.getAbsoluteFileAsFile(this.getBaseDir(), filename);
                DocumentContext context = JsonPath.parse((File)jsonFile);
                List docs = (List)context.read(documentSelector, List.class, new Predicate[0]);
                for (Object doc : docs) {
                    String id = null;
                    id = idSelector != null ? (String)JsonPath.parse(doc).read(idSelector, new Predicate[0]) : UUID.randomUUID().toString();
                    FileUtils.writeStringToFile((File)new File(outputPrefix + id + fileExtension), (String)gson.toJson(doc), (String)"UTF-8");
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

