/*
 * Decompiled with CFR 0.152.
 */
package de.tblsoft.solr.pipeline.processor;

import de.tblsoft.solr.pipeline.AbstractProcessor;
import de.tblsoft.solr.util.IOUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;

public class LineProcessor
extends AbstractProcessor {
    private Long currentLine = 0L;
    private Long skipLines = 1L;
    private String charset = StandardCharsets.UTF_8.name();
    private String absoluteInputFilename;
    private String absoluteOutputFilename;

    @Override
    public void process() {
        try {
            String line;
            this.init();
            InputStream in = IOUtils.getInputStream(this.absoluteInputFilename);
            InputStreamReader reader = new InputStreamReader(in, this.charset);
            OutputStream out = IOUtils.getOutputStream(this.absoluteOutputFilename);
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out, this.charset));
            BufferedReader br = new BufferedReader(reader);
            while ((line = br.readLine()) != null) {
                Long l = this.currentLine;
                Long l2 = this.currentLine = Long.valueOf(this.currentLine + 1L);
                String processedLine = this.processLine(line);
                if (processedLine == null) continue;
                writer.write(line);
                writer.newLine();
            }
            ((Reader)reader).close();
            writer.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void init() {
        this.charset = this.getProperty("charset", this.charset);
        this.skipLines = this.getPropertyAsInteger("skipLines", this.skipLines);
        String inputFilename = this.getProperty("inputFilename", null);
        this.absoluteInputFilename = IOUtils.getAbsoluteFile(this.getBaseDir(), inputFilename);
        String outputFilename = this.getProperty("outputFilename", null);
        this.absoluteOutputFilename = IOUtils.getAbsoluteFile(this.getBaseDir(), outputFilename);
    }

    public String processLine(String line) {
        return line;
    }

    public Long getCurrentLine() {
        return this.currentLine;
    }

    public Long getSkipLines() {
        return this.skipLines;
    }

    public String getCharset() {
        return this.charset;
    }

    public String getAbsoluteInputFilename() {
        return this.absoluteInputFilename;
    }

    public String getAbsoluteOutputFilename() {
        return this.absoluteOutputFilename;
    }
}

