/*
 * Decompiled with CFR 0.152.
 */
package de.tblsoft.solr.pipeline.processor;

import com.google.common.io.CharSink;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import de.tblsoft.solr.pipeline.AbstractProcessor;
import de.tblsoft.solr.pipeline.processor.DistinctFunction;
import de.tblsoft.solr.util.IOUtils;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;

public class ListDiffProcessor
extends AbstractProcessor {
    private String charset = StandardCharsets.UTF_8.name();
    private String absoluteOutputFilename;
    private List<String> inputFiles;
    private List<Function> functions = new ArrayList<Function>();
    private String mode = "intersection";

    @Override
    public void process() {
        try {
            this.init();
            this.functions.add(new DistinctFunction());
            List outputList = null;
            for (String inputFile : this.inputFiles) {
                String absoluteInputFile = IOUtils.getAbsoluteFile(this.getBaseDir(), inputFile);
                List lines = Files.readLines((File)new File(absoluteInputFile), (Charset)Charset.forName(this.charset));
                Stream<Object> stream = lines.stream();
                for (Function function : this.functions) {
                    if (function instanceof DistinctFunction) {
                        stream = stream.distinct();
                        continue;
                    }
                    stream = stream.map(function);
                }
                if (outputList == null) {
                    outputList = lines;
                    continue;
                }
                if ("intersection".equals(this.mode)) {
                    outputList.retainAll(lines);
                    continue;
                }
                if (!"disjunction".equals(this.mode)) continue;
                outputList.removeAll(lines);
            }
            CharSink sink = Files.asCharSink((File)new File(this.absoluteOutputFilename), (Charset)Charset.forName(this.charset), (FileWriteMode[])new FileWriteMode[0]);
            sink.writeLines(outputList);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void init() {
        this.charset = this.getProperty("charset", this.charset);
        this.mode = this.getProperty("mode", this.mode);
        this.inputFiles = this.getPropertyAsList("inputFiles", new ArrayList<String>());
        String outputFilename = this.getProperty("outputFilename", null);
        this.absoluteOutputFilename = IOUtils.getAbsoluteFile(this.getBaseDir(), outputFilename);
    }

    public String getCharset() {
        return this.charset;
    }

    public String getAbsoluteOutputFilename() {
        return this.absoluteOutputFilename;
    }
}

