/*
 * Decompiled with CFR 0.152.
 */
package de.tblsoft.solr.pipeline.processor;

import de.tblsoft.solr.pipeline.AbstractProcessor;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import opennlp.tools.postag.POSModel;
import opennlp.tools.postag.POSTaggerFactory;
import opennlp.tools.postag.POSTaggerME;
import opennlp.tools.postag.WordTagSampleStream;
import opennlp.tools.util.InputStreamFactory;
import opennlp.tools.util.MarkableFileInputStreamFactory;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.PlainTextByLineStream;
import opennlp.tools.util.TrainingParameters;

public class OpenNLPPosTaggerTrainProcessor
extends AbstractProcessor {
    private String trainingInputFile;
    private String modelOutputfile;
    private String trainingInputFileCharSet;
    private String languageCode;

    @Override
    public void process() {
        this.trainingInputFile = this.getProperty("trainingInputFile", "train.txt");
        this.modelOutputfile = this.getProperty("modelOutputfile", "model.bin");
        this.trainingInputFileCharSet = this.getProperty("trainingInputFileCharSet", "UTF-8");
        this.languageCode = this.getProperty("languageCode", "de");
        this.train();
    }

    private void train() {
        try {
            MarkableFileInputStreamFactory inputStreamFactory = new MarkableFileInputStreamFactory(new File(this.getBaseDir() + "/" + this.trainingInputFile));
            PlainTextByLineStream lineStream = new PlainTextByLineStream((InputStreamFactory)inputStreamFactory, this.trainingInputFileCharSet);
            WordTagSampleStream sampleStream = new WordTagSampleStream((ObjectStream)lineStream);
            POSModel model = POSTaggerME.train((String)this.languageCode, (ObjectStream)sampleStream, (TrainingParameters)TrainingParameters.defaultParams(), (POSTaggerFactory)new POSTaggerFactory());
            BufferedOutputStream modelOut = new BufferedOutputStream(new FileOutputStream(this.getBaseDir() + "/" + this.modelOutputfile));
            model.serialize((OutputStream)modelOut);
            ((OutputStream)modelOut).close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

