/*
 * Decompiled with CFR 0.152.
 */
package de.tblsoft.solr.pipeline.test;

import de.tblsoft.solr.pipeline.bean.Document;
import de.tblsoft.solr.pipeline.bean.Field;
import de.tblsoft.solr.pipeline.filter.JsonWriter;
import de.tblsoft.solr.pipeline.filter.TestingFilter;
import java.util.ArrayList;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBaseTest {
    private static Logger LOG = LoggerFactory.getLogger(AbstractBaseTest.class);
    protected List<Document> outputDocumentList = new ArrayList<Document>();
    protected TestingFilter testingFilter;

    public void print(List<Document> documentList) {
        String json = JsonWriter.mapToJsonString(documentList);
        LOG.info(json);
    }

    public void print() {
        this.print(this.outputDocumentList);
    }

    public void assertFiled(int position, String name, String expected) {
        if (this.outputDocumentList.size() <= position) {
            Assert.fail((String)("There is no output document for position: " + position));
        }
        Document document = this.outputDocumentList.get(position);
        String actual = document.getFieldValue(name);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    public void assertFiled(String name, String expected) {
        this.assertFiled(0, name, expected);
    }

    public void assertFiledNotExists(String name) {
        if (this.outputDocumentList.size() == 0) {
            Assert.fail((String)"There is no output document.");
        }
        Document document = this.outputDocumentList.get(0);
        Field f = document.getField(name);
        Assert.assertNull((Object)f);
    }

    public void assertFiledExists(String name) {
        if (this.outputDocumentList.size() == 0) {
            Assert.fail((String)"There is no output document.");
        }
        Document document = this.outputDocumentList.get(0);
        Field f = document.getField(name);
        Assert.assertNotNull((Object)f);
    }

    public void assertFiledList(String name, String ... expected) {
        Document document = this.outputDocumentList.get(0);
        List<String> actual = document.getFieldValues(name);
        Assert.assertThat(actual, (Matcher)CoreMatchers.hasItems((Object[])expected));
    }

    public void assertNumberOfDocuments(int expected) {
        int actual = this.outputDocumentList.size();
        Assert.assertEquals((long)expected, (long)actual);
    }

    public void assertNumberOfFields(int expected) {
        int actual = this.outputDocumentList.get(0).getFields().size();
        Assert.assertEquals((long)expected, (long)actual);
    }

    public void assertInitWasDelegated() {
        Assert.assertTrue((boolean)this.testingFilter.isInitWasDelegated());
    }

    public void assertEndWasDelegated() {
        Assert.assertTrue((boolean)this.testingFilter.isEndWasDelegated());
    }
}

