/*
 * Decompiled with CFR 0.152.
 */
package de.tblsoft.solr.pipeline.test;

import de.tblsoft.solr.pipeline.FilterIF;
import de.tblsoft.solr.pipeline.PipelineExecuter;
import de.tblsoft.solr.pipeline.bean.Document;
import de.tblsoft.solr.pipeline.bean.DocumentBuilder;
import de.tblsoft.solr.pipeline.bean.DocumentComparator;
import de.tblsoft.solr.pipeline.bean.Filter;
import de.tblsoft.solr.pipeline.filter.LastFilter;
import de.tblsoft.solr.pipeline.filter.TestingFilter;
import de.tblsoft.solr.pipeline.test.AbstractBaseTest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.junit.Before;
import org.junit.Test;

public abstract class AbstractFilterTest
extends AbstractBaseTest {
    private Filter filterConfig = new Filter();
    private Document inputDocument = new Document();

    @Before
    public void before() {
        this.outputDocumentList.clear();
        this.inputDocument = DocumentBuilder.document().create();
        this.filterConfig = new Filter();
        this.testingFilter = null;
    }

    public void runTest() {
        this.document(this.inputDocument);
    }

    public void createField(String name, String value) {
        this.inputDocument.addField(name, value);
    }

    public abstract void configure();

    @Test
    public void testEmptyDocument() {
        this.configure();
        this.runTest();
        this.assertNumberOfDocuments(1);
        this.assertNumberOfFields(0);
    }

    @Test
    public void testPassthrough() {
        this.configure();
        this.createField("foo", "bar");
        this.runTest();
        this.assertFiled("foo", "bar");
        this.assertNumberOfDocuments(1);
        this.assertNumberOfFields(1);
        this.assertInitWasDelegated();
        this.assertEndWasDelegated();
    }

    public void putProperty(String key, String value) {
        this.filterConfig.putProperty(key, value);
    }

    public void addProperty(String key, String value) {
        ArrayList<String> propertyList = (ArrayList<String>)this.filterConfig.getProperty().get(key);
        if (propertyList == null) {
            propertyList = new ArrayList<String>();
        }
        propertyList.add(value);
        this.filterConfig.putPropertyList(key, propertyList);
    }

    public void setClazz(Class clazz) {
        this.filterConfig.setClazz(clazz.getName());
    }

    protected List<Document> document(Document document) {
        FilterIF filter = this.initFilter();
        filter.document(document);
        filter.end();
        this.outputDocumentList = this.testingFilter.getDocumentList();
        return this.outputDocumentList;
    }

    protected List<Document> document(Document ... document) {
        FilterIF filter = this.initFilter();
        for (Document d : document) {
            filter.document(d);
        }
        filter.end();
        this.outputDocumentList = this.testingFilter.getDocumentList();
        return this.outputDocumentList;
    }

    FilterIF initFilter() {
        FilterIF filter = PipelineExecuter.createFilterInstance(this.filterConfig);
        this.testingFilter = new TestingFilter();
        this.testingFilter.setNextFilter(new LastFilter());
        filter.setNextFilter(this.testingFilter);
        filter.init();
        return filter;
    }

    protected void sortDocumentListByField(String fieldName) {
        Collections.sort(this.outputDocumentList, new DocumentComparator(fieldName));
    }
}

