/*
 * Decompiled with CFR 0.152.
 */
package de.tblsoft.solr.schema;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.request.schema.SchemaRequest;
import org.apache.solr.client.solrj.response.schema.SchemaResponse;

public class SolrSchemaManager {
    private SolrClient solrClient;
    private static Map<String, String> dataTypeMapping = new HashMap<String, String>();
    private List<String> fieldBlackList = new ArrayList<String>();

    public SolrSchemaManager(String solrUrl) {
        this.solrClient = new HttpSolrClient(solrUrl);
        this.fieldBlackList.add("_text_");
        this.fieldBlackList.add("_version_");
        this.fieldBlackList.add("id");
    }

    public void addField(String name, String type, boolean multivalue) throws IOException, SolrServerException {
        String mappedType = dataTypeMapping.get(type);
        if (mappedType == null) {
            mappedType = type;
        }
        HashMap<String, Object> fieldAttributes = new HashMap<String, Object>();
        fieldAttributes.put("name", name);
        fieldAttributes.put("type", mappedType);
        fieldAttributes.put("stored", true);
        fieldAttributes.put("indexed", true);
        fieldAttributes.put("multiValued", multivalue);
        fieldAttributes.put("required", false);
        SchemaRequest.AddField schemaRequest = new SchemaRequest.AddField(fieldAttributes);
        SchemaResponse.UpdateResponse response = (SchemaResponse.UpdateResponse)schemaRequest.process(this.solrClient);
    }

    public void addField(String name) throws IOException, SolrServerException {
        this.addField(name, "string", false);
    }

    public void deleteField(String name) throws IOException, SolrServerException {
        if (this.fieldBlackList.contains(name)) {
            return;
        }
        SchemaRequest.DeleteField deleteFieldRequest = new SchemaRequest.DeleteField(name);
        SchemaResponse.UpdateResponse deleteFieldResponse = (SchemaResponse.UpdateResponse)deleteFieldRequest.process(this.solrClient);
    }

    public List<String> getAllFields() throws IOException, SolrServerException {
        ArrayList<String> allFields = new ArrayList<String>();
        SchemaRequest.Fields listFields = new SchemaRequest.Fields();
        SchemaResponse.FieldsResponse fieldsResponse = (SchemaResponse.FieldsResponse)listFields.process(this.solrClient);
        List solrFields = fieldsResponse.getFields();
        for (Map field : solrFields) {
            allFields.add((String)field.get("name"));
        }
        return allFields;
    }

    public void deleteAllFields() throws IOException, SolrServerException {
        for (String fieldName : this.getAllFields()) {
            this.deleteField(fieldName);
        }
    }

    static {
        dataTypeMapping.put("integer", "int");
    }
}

