/*
 * Decompiled with CFR 0.152.
 */
package de.tblsoft.solr.util;

import de.tblsoft.solr.http.HTTPHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;

public class IOUtils {
    public static String getAbsoluteFile(String directory, String fileName) {
        if (fileName.toLowerCase().startsWith("http")) {
            return fileName;
        }
        if (fileName.toLowerCase().startsWith("classpath:")) {
            return fileName;
        }
        if (fileName.toLowerCase().startsWith("c:\\")) {
            return fileName;
        }
        if (fileName.startsWith("/")) {
            return fileName;
        }
        if (fileName.startsWith("./")) {
            return fileName;
        }
        return directory + "/" + fileName;
    }

    public static File getAbsoluteFileAsFile(String directory, String fileName) {
        return new File(IOUtils.getAbsoluteFile(directory, fileName));
    }

    public static String getDirectoryForFile(String file) {
        File f = new File(file);
        File currentPath = new File(f.getParent());
        return currentPath.getName();
    }

    public static List<String> getFiles(String path) {
        ArrayList<String> fileList = new ArrayList<String>();
        File root = new File(path);
        if (path.contains("*")) {
            WildcardFileFilter fileFilter = new WildcardFileFilter(root.getName());
            WildcardFileFilter dirFilter = new WildcardFileFilter("*");
            Collection files = FileUtils.listFiles((File)root.getParentFile(), (IOFileFilter)fileFilter, (IOFileFilter)dirFilter);
            for (File file : files) {
                fileList.add(file.getAbsolutePath());
            }
            return fileList;
        }
        if (root.isFile()) {
            fileList.add(path);
            return fileList;
        }
        if (root.isDirectory()) {
            for (File file : com.google.common.io.Files.fileTraverser().breadthFirst((Object)root)) {
                if (!file.isFile()) continue;
                fileList.add(file.getAbsolutePath());
            }
            return fileList;
        }
        throw new RuntimeException("The file or path does not exists: " + path);
    }

    public static InputStream getInputStream(File inputFile) throws IOException {
        return IOUtils.getInputStream(inputFile.getAbsolutePath());
    }

    public static InputStream getInputStream(String inputFileName) throws IOException {
        InputStream inputStream;
        if (inputFileName.startsWith("http")) {
            inputStream = HTTPHelper.getAsInputStream(inputFileName);
        } else {
            if (inputFileName.startsWith("classpath:")) {
                String classpath = inputFileName.replaceFirst("classpath:", "");
                return IOUtils.class.getResourceAsStream(classpath);
            }
            inputStream = new FileInputStream(inputFileName);
        }
        if (inputFileName.endsWith(".gz")) {
            return new GZIPInputStream(inputStream);
        }
        if (inputFileName.endsWith(".bz2")) {
            return new BZip2CompressorInputStream(inputStream);
        }
        return inputStream;
    }

    public static String getString(String location) throws IOException {
        if (location.startsWith("http")) {
            return HTTPHelper.get(location);
        }
        return FileUtils.readFileToString((File)new File(location));
    }

    public static OutputStream getOutputStream(File outputFile) throws IOException {
        return IOUtils.getOutputStream(outputFile.getAbsolutePath());
    }

    public static OutputStream getOutputStream(String outputFileName) throws IOException {
        if ("stdout".equals(outputFileName)) {
            return System.out;
        }
        if ("stderr".equals(outputFileName)) {
            return System.err;
        }
        if (outputFileName.endsWith(".gz")) {
            FileOutputStream out = new FileOutputStream(outputFileName);
            return new GZIPOutputStream(out);
        }
        return new FileOutputStream(outputFileName);
    }

    public static void appendToOutputStream(OutputStream out, String value) throws IOException {
        out.write(value.getBytes("UTF-8"));
    }

    public static List<String> file2List(String fileName) throws IOException {
        return IOUtils.file2List(fileName, StandardCharsets.UTF_8);
    }

    public static List<String> file2List(String fileName, Charset charSet) throws IOException {
        Stream<String> lines = Files.lines(Paths.get(fileName, new String[0]), charSet);
        List<String> result = lines.collect(Collectors.toList());
        return result;
    }
}

