/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qgame.animplayer;

import android.os.SystemClock;
import com.tencent.qgame.animplayer.AnimConfig;
import com.tencent.qgame.animplayer.AnimPlayer;
import com.tencent.qgame.animplayer.PointRect;
import com.tencent.qgame.animplayer.file.IFileContainer;
import com.tencent.qgame.animplayer.util.ALog;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0005\u0018\u0000 #2\u00020\u0001:\u0002\"#B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015J \u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u0015H\u0002J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J&\u0010 \u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010!\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u0015R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006$"}, d2={"Lcom/tencent/qgame/animplayer/AnimConfigManager;", "", "player", "Lcom/tencent/qgame/animplayer/AnimPlayer;", "(Lcom/tencent/qgame/animplayer/AnimPlayer;)V", "config", "Lcom/tencent/qgame/animplayer/AnimConfig;", "getConfig", "()Lcom/tencent/qgame/animplayer/AnimConfig;", "setConfig", "(Lcom/tencent/qgame/animplayer/AnimConfig;)V", "isParsingConfig", "", "()Z", "setParsingConfig", "(Z)V", "getPlayer", "()Lcom/tencent/qgame/animplayer/AnimPlayer;", "defaultConfig", "", "_videoWidth", "", "_videoHeight", "parse", "fileContainer", "Lcom/tencent/qgame/animplayer/file/IFileContainer;", "defaultVideoMode", "defaultFps", "parseBoxHead", "Lcom/tencent/qgame/animplayer/AnimConfigManager$BoxHead;", "boxHead", "", "parseConfig", "enableVersion1", "BoxHead", "Companion", "animplayer_release"})
public final class AnimConfigManager {
    @Nullable
    private AnimConfig config;
    private boolean isParsingConfig;
    @NotNull
    private final AnimPlayer player;
    private static final String TAG = "AnimPlayer.AnimConfigManager";
    public static final Companion Companion = new Companion(null);

    @Nullable
    public final AnimConfig getConfig() {
        return this.config;
    }

    public final void setConfig(@Nullable AnimConfig animConfig) {
        this.config = animConfig;
    }

    public final boolean isParsingConfig() {
        return this.isParsingConfig;
    }

    public final void setParsingConfig(boolean bl) {
        this.isParsingConfig = bl;
    }

    public final int parseConfig(@NotNull IFileContainer fileContainer, boolean enableVersion1, int defaultVideoMode, int defaultFps) {
        Intrinsics.checkParameterIsNotNull((Object)fileContainer, (String)"fileContainer");
        try {
            int n;
            this.isParsingConfig = true;
            long time = SystemClock.elapsedRealtime();
            boolean result = this.parse(fileContainer, defaultVideoMode, defaultFps);
            ALog.INSTANCE.i(TAG, "parseConfig cost=" + (SystemClock.elapsedRealtime() - time) + "ms enableVersion1=" + enableVersion1 + " result=" + result);
            if (!result) {
                this.isParsingConfig = false;
                return 10005;
            }
            AnimConfig animConfig = this.config;
            if (animConfig != null) {
                if (animConfig.isDefaultConfig()) {
                    if (!enableVersion1) {
                        this.isParsingConfig = false;
                        return 10005;
                    }
                }
            }
            AnimConfig animConfig2 = this.config;
            if (animConfig2 != null) {
                AnimConfig animConfig3 = animConfig2;
                boolean bl = false;
                boolean bl2 = false;
                AnimConfig it = animConfig3;
                boolean bl3 = false;
                n = this.player.getPluginManager().onConfigCreate(it);
            } else {
                n = 0;
            }
            int resultCode = n;
            this.isParsingConfig = false;
            return resultCode;
        }
        catch (Throwable e) {
            ALog.INSTANCE.e(TAG, "parseConfig error " + e, e);
            this.isParsingConfig = false;
            return 10005;
        }
    }

    public final void defaultConfig(int _videoWidth, int _videoHeight) {
        block8: {
            AnimConfig animConfig = this.config;
            if (animConfig != null) {
                if (!animConfig.isDefaultConfig()) {
                    return;
                }
            }
            AnimConfig animConfig2 = this.config;
            if (animConfig2 == null) break block8;
            AnimConfig animConfig3 = animConfig2;
            boolean bl = false;
            boolean bl2 = false;
            AnimConfig $this$apply = animConfig3;
            boolean bl3 = false;
            $this$apply.setVideoWidth(_videoWidth);
            $this$apply.setVideoHeight(_videoHeight);
            switch ($this$apply.getDefaultVideoMode()) {
                case 1: {
                    $this$apply.setWidth(_videoWidth / 2);
                    $this$apply.setHeight(_videoHeight);
                    $this$apply.setAlphaPointRect(new PointRect(0, 0, $this$apply.getWidth(), $this$apply.getHeight()));
                    $this$apply.setRgbPointRect(new PointRect($this$apply.getWidth(), 0, $this$apply.getWidth(), $this$apply.getHeight()));
                    break;
                }
                case 2: {
                    $this$apply.setWidth(_videoWidth);
                    $this$apply.setHeight(_videoHeight / 2);
                    $this$apply.setAlphaPointRect(new PointRect(0, 0, $this$apply.getWidth(), $this$apply.getHeight()));
                    $this$apply.setRgbPointRect(new PointRect(0, $this$apply.getHeight(), $this$apply.getWidth(), $this$apply.getHeight()));
                    break;
                }
                case 3: {
                    $this$apply.setWidth(_videoWidth / 2);
                    $this$apply.setHeight(_videoHeight);
                    $this$apply.setRgbPointRect(new PointRect(0, 0, $this$apply.getWidth(), $this$apply.getHeight()));
                    $this$apply.setAlphaPointRect(new PointRect($this$apply.getWidth(), 0, $this$apply.getWidth(), $this$apply.getHeight()));
                    break;
                }
                case 4: {
                    $this$apply.setWidth(_videoWidth);
                    $this$apply.setHeight(_videoHeight / 2);
                    $this$apply.setRgbPointRect(new PointRect(0, 0, $this$apply.getWidth(), $this$apply.getHeight()));
                    $this$apply.setAlphaPointRect(new PointRect(0, $this$apply.getHeight(), $this$apply.getWidth(), $this$apply.getHeight()));
                    break;
                }
                default: {
                    $this$apply.setWidth(_videoWidth / 2);
                    $this$apply.setHeight(_videoHeight);
                    $this$apply.setAlphaPointRect(new PointRect(0, 0, $this$apply.getWidth(), $this$apply.getHeight()));
                    $this$apply.setRgbPointRect(new PointRect($this$apply.getWidth(), 0, $this$apply.getWidth(), $this$apply.getHeight()));
                }
            }
        }
    }

    private final boolean parse(IFileContainer fileContainer, int defaultVideoMode, int defaultFps) {
        AnimConfig h;
        AnimConfig config;
        this.config = config = new AnimConfig();
        fileContainer.startRandomRead();
        byte[] boxHead = new byte[8];
        Object head = null;
        long vapcStartIndex = 0L;
        while (fileContainer.read(boxHead, 0, boxHead.length) == 8) {
            if (this.parseBoxHead(boxHead) == null) {
                break;
            }
            if (Intrinsics.areEqual((Object)"vapc", (Object)((BoxHead)((Object)h)).getType())) {
                ((BoxHead)((Object)h)).setStartIndex(vapcStartIndex);
                head = h;
                break;
            }
            vapcStartIndex += (long)((BoxHead)((Object)h)).getLength();
            fileContainer.skip((long)((BoxHead)((Object)h)).getLength() - 8L);
        }
        if (head == null) {
            ALog.INSTANCE.e(TAG, "vapc box head not found");
            h = config;
            boolean bl = false;
            boolean bl2 = false;
            AnimConfig $this$apply = h;
            boolean bl3 = false;
            $this$apply.setDefaultConfig(true);
            $this$apply.setDefaultVideoMode(defaultVideoMode);
            $this$apply.setFps(defaultFps);
            this.player.setFps(config.getFps());
            return true;
        }
        byte[] vapcBuf = new byte[((BoxHead)head).getLength() - 8];
        fileContainer.read(vapcBuf, 0, vapcBuf.length);
        fileContainer.closeRandomRead();
        int n = 0;
        int $this$apply = vapcBuf.length;
        Charset charset = Charset.forName("UTF-8");
        Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"Charset.forName(\"UTF-8\")");
        Charset charset2 = charset;
        boolean bl = false;
        String json = new String(vapcBuf, n, $this$apply, charset2);
        JSONObject jsonObj = new JSONObject(json);
        config.setJsonConfig(jsonObj);
        boolean result = config.parse(jsonObj);
        if (defaultFps > 0) {
            config.setFps(defaultFps);
        }
        this.player.setFps(config.getFps());
        return result;
    }

    private final BoxHead parseBoxHead(byte[] boxHead) {
        if (boxHead.length != 8) {
            return null;
        }
        BoxHead head = new BoxHead();
        int length = 0;
        length |= (boxHead[0] & 0xFF) << 24;
        length |= (boxHead[1] & 0xFF) << 16;
        length |= (boxHead[2] & 0xFF) << 8;
        head.setLength(length |= boxHead[3] & 0xFF);
        int n = 4;
        int n2 = 4;
        Charset charset = Charset.forName("US-ASCII");
        Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"Charset.forName(\"US-ASCII\")");
        Charset charset2 = charset;
        BoxHead boxHead2 = head;
        boolean bl = false;
        String string = new String(boxHead, n, n2, charset2);
        boxHead2.setType(string);
        return head;
    }

    @NotNull
    public final AnimPlayer getPlayer() {
        return this.player;
    }

    public AnimConfigManager(@NotNull AnimPlayer player) {
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        this.player = player;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lcom/tencent/qgame/animplayer/AnimConfigManager$BoxHead;", "", "()V", "length", "", "getLength", "()I", "setLength", "(I)V", "startIndex", "", "getStartIndex", "()J", "setStartIndex", "(J)V", "type", "", "getType", "()Ljava/lang/String;", "setType", "(Ljava/lang/String;)V", "animplayer_release"})
    private static final class BoxHead {
        private long startIndex;
        private int length;
        @Nullable
        private String type;

        public final long getStartIndex() {
            return this.startIndex;
        }

        public final void setStartIndex(long l) {
            this.startIndex = l;
        }

        public final int getLength() {
            return this.length;
        }

        public final void setLength(int n) {
            this.length = n;
        }

        @Nullable
        public final String getType() {
            return this.type;
        }

        public final void setType(@Nullable String string) {
            this.type = string;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/tencent/qgame/animplayer/AnimConfigManager$Companion;", "", "()V", "TAG", "", "animplayer_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

