/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qgame.animplayer;

import android.graphics.Bitmap;
import com.tencent.qgame.animplayer.AnimConfig;
import com.tencent.qgame.animplayer.AnimConfigManager;
import com.tencent.qgame.animplayer.AudioPlayer;
import com.tencent.qgame.animplayer.Constant;
import com.tencent.qgame.animplayer.Decoder;
import com.tencent.qgame.animplayer.HandlerHolder;
import com.tencent.qgame.animplayer.HardDecoder;
import com.tencent.qgame.animplayer.IAnimView;
import com.tencent.qgame.animplayer.PointRect;
import com.tencent.qgame.animplayer.RefVec2;
import com.tencent.qgame.animplayer.file.IFileContainer;
import com.tencent.qgame.animplayer.inter.IAnimListener;
import com.tencent.qgame.animplayer.mask.MaskConfig;
import com.tencent.qgame.animplayer.plugin.AnimPluginManager;
import com.tencent.qgame.animplayer.util.ALog;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 [2\u00020\u0001:\u0001[B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010K\u001a\u00020L2\u0006\u0010M\u001a\u00020NH\u0002J\u0006\u0010O\u001a\u00020$J\u0016\u0010P\u001a\u00020L2\u0006\u0010Q\u001a\u00020\u001e2\u0006\u0010R\u001a\u00020\u001eJ\u0006\u0010S\u001a\u00020LJ\u0016\u0010T\u001a\u00020L2\u0006\u0010Q\u001a\u00020\u001e2\u0006\u0010R\u001a\u00020\u001eJ\b\u0010U\u001a\u00020LH\u0002J\u000e\u0010V\u001a\u00020L2\u0006\u0010M\u001a\u00020NJ\u0006\u0010W\u001a\u00020LJ\u0010\u0010X\u001a\u00020L2\b\u0010Y\u001a\u0004\u0018\u00010ZR\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001c\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001c\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\u00020\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u001a\u0010#\u001a\u00020$X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R$\u0010*\u001a\u00020\u001e2\u0006\u0010)\u001a\u00020\u001e@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010 \"\u0004\b,\u0010\"R\u001a\u0010-\u001a\u00020$X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010&\"\u0004\b.\u0010(R\u001a\u0010/\u001a\u00020$X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u0010&\"\u0004\b0\u0010(R\u001a\u00101\u001a\u00020$X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u0010&\"\u0004\b2\u0010(R\u001a\u00103\u001a\u00020$X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u0010&\"\u0004\b4\u0010(R\u001a\u00105\u001a\u00020$X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u0010&\"\u0004\b7\u0010(R$\u00108\u001a\u00020\u001e2\u0006\u0010)\u001a\u00020\u001e@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b9\u0010 \"\u0004\b:\u0010\"R\u0011\u0010;\u001a\u00020<\u00a2\u0006\b\n\u0000\u001a\u0004\b=\u0010>R\u001c\u0010?\u001a\u0004\u0018\u00010@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bA\u0010B\"\u0004\bC\u0010DR\u001a\u0010E\u001a\u00020$X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bF\u0010&\"\u0004\bG\u0010(R\u001a\u0010H\u001a\u00020\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bI\u0010 \"\u0004\bJ\u0010\"\u00a8\u0006\\"}, d2={"Lcom/tencent/qgame/animplayer/AnimPlayer;", "", "animView", "Lcom/tencent/qgame/animplayer/IAnimView;", "(Lcom/tencent/qgame/animplayer/IAnimView;)V", "animListener", "Lcom/tencent/qgame/animplayer/inter/IAnimListener;", "getAnimListener", "()Lcom/tencent/qgame/animplayer/inter/IAnimListener;", "setAnimListener", "(Lcom/tencent/qgame/animplayer/inter/IAnimListener;)V", "getAnimView", "()Lcom/tencent/qgame/animplayer/IAnimView;", "audioPlayer", "Lcom/tencent/qgame/animplayer/AudioPlayer;", "getAudioPlayer", "()Lcom/tencent/qgame/animplayer/AudioPlayer;", "setAudioPlayer", "(Lcom/tencent/qgame/animplayer/AudioPlayer;)V", "configManager", "Lcom/tencent/qgame/animplayer/AnimConfigManager;", "getConfigManager", "()Lcom/tencent/qgame/animplayer/AnimConfigManager;", "decoder", "Lcom/tencent/qgame/animplayer/Decoder;", "getDecoder", "()Lcom/tencent/qgame/animplayer/Decoder;", "setDecoder", "(Lcom/tencent/qgame/animplayer/Decoder;)V", "defaultFps", "", "getDefaultFps", "()I", "setDefaultFps", "(I)V", "enableVersion1", "", "getEnableVersion1", "()Z", "setEnableVersion1", "(Z)V", "value", "fps", "getFps", "setFps", "isDetachedFromWindow", "setDetachedFromWindow", "isMute", "setMute", "isStartRunning", "setStartRunning", "isSurfaceAvailable", "setSurfaceAvailable", "maskEdgeBlurBoolean", "getMaskEdgeBlurBoolean", "setMaskEdgeBlurBoolean", "playLoop", "getPlayLoop", "setPlayLoop", "pluginManager", "Lcom/tencent/qgame/animplayer/plugin/AnimPluginManager;", "getPluginManager", "()Lcom/tencent/qgame/animplayer/plugin/AnimPluginManager;", "startRunnable", "Ljava/lang/Runnable;", "getStartRunnable", "()Ljava/lang/Runnable;", "setStartRunnable", "(Ljava/lang/Runnable;)V", "supportMaskBoolean", "getSupportMaskBoolean", "setSupportMaskBoolean", "videoMode", "getVideoMode", "setVideoMode", "innerStartPlay", "", "fileContainer", "Lcom/tencent/qgame/animplayer/file/IFileContainer;", "isRunning", "onSurfaceTextureAvailable", "width", "height", "onSurfaceTextureDestroyed", "onSurfaceTextureSizeChanged", "prepareDecoder", "startPlay", "stopPlay", "updateMaskConfig", "maskConfig", "Lcom/tencent/qgame/animplayer/mask/MaskConfig;", "Companion", "animplayer_release"})
public final class AnimPlayer {
    @Nullable
    private IAnimListener animListener;
    @Nullable
    private Decoder decoder;
    @Nullable
    private AudioPlayer audioPlayer;
    private int fps;
    private int defaultFps;
    private int playLoop;
    private boolean supportMaskBoolean;
    private boolean maskEdgeBlurBoolean;
    private boolean enableVersion1;
    private int videoMode;
    private boolean isDetachedFromWindow;
    private boolean isSurfaceAvailable;
    @Nullable
    private Runnable startRunnable;
    private boolean isStartRunning;
    private boolean isMute;
    @NotNull
    private final AnimConfigManager configManager;
    @NotNull
    private final AnimPluginManager pluginManager;
    @NotNull
    private final IAnimView animView;
    private static final String TAG = "AnimPlayer.AnimPlayer";
    public static final Companion Companion = new Companion(null);

    @Nullable
    public final IAnimListener getAnimListener() {
        return this.animListener;
    }

    public final void setAnimListener(@Nullable IAnimListener iAnimListener) {
        this.animListener = iAnimListener;
    }

    @Nullable
    public final Decoder getDecoder() {
        return this.decoder;
    }

    public final void setDecoder(@Nullable Decoder decoder) {
        this.decoder = decoder;
    }

    @Nullable
    public final AudioPlayer getAudioPlayer() {
        return this.audioPlayer;
    }

    public final void setAudioPlayer(@Nullable AudioPlayer audioPlayer) {
        this.audioPlayer = audioPlayer;
    }

    public final int getFps() {
        return this.fps;
    }

    public final void setFps(int value) {
        Decoder decoder = this.decoder;
        if (decoder != null) {
            decoder.setFps(value);
        }
        this.fps = value;
    }

    public final int getDefaultFps() {
        return this.defaultFps;
    }

    public final void setDefaultFps(int n) {
        this.defaultFps = n;
    }

    public final int getPlayLoop() {
        return this.playLoop;
    }

    public final void setPlayLoop(int value) {
        Decoder decoder = this.decoder;
        if (decoder != null) {
            decoder.setPlayLoop(value);
        }
        AudioPlayer audioPlayer = this.audioPlayer;
        if (audioPlayer != null) {
            audioPlayer.setPlayLoop(value);
        }
        this.playLoop = value;
    }

    public final boolean getSupportMaskBoolean() {
        return this.supportMaskBoolean;
    }

    public final void setSupportMaskBoolean(boolean bl) {
        this.supportMaskBoolean = bl;
    }

    public final boolean getMaskEdgeBlurBoolean() {
        return this.maskEdgeBlurBoolean;
    }

    public final void setMaskEdgeBlurBoolean(boolean bl) {
        this.maskEdgeBlurBoolean = bl;
    }

    public final boolean getEnableVersion1() {
        return this.enableVersion1;
    }

    public final void setEnableVersion1(boolean bl) {
        this.enableVersion1 = bl;
    }

    public final int getVideoMode() {
        return this.videoMode;
    }

    public final void setVideoMode(int n) {
        this.videoMode = n;
    }

    public final boolean isDetachedFromWindow() {
        return this.isDetachedFromWindow;
    }

    public final void setDetachedFromWindow(boolean bl) {
        this.isDetachedFromWindow = bl;
    }

    public final boolean isSurfaceAvailable() {
        return this.isSurfaceAvailable;
    }

    public final void setSurfaceAvailable(boolean bl) {
        this.isSurfaceAvailable = bl;
    }

    @Nullable
    public final Runnable getStartRunnable() {
        return this.startRunnable;
    }

    public final void setStartRunnable(@Nullable Runnable runnable) {
        this.startRunnable = runnable;
    }

    public final boolean isStartRunning() {
        return this.isStartRunning;
    }

    public final void setStartRunning(boolean bl) {
        this.isStartRunning = bl;
    }

    public final boolean isMute() {
        return this.isMute;
    }

    public final void setMute(boolean bl) {
        this.isMute = bl;
    }

    @NotNull
    public final AnimConfigManager getConfigManager() {
        return this.configManager;
    }

    @NotNull
    public final AnimPluginManager getPluginManager() {
        return this.pluginManager;
    }

    public final void onSurfaceTextureDestroyed() {
        block1: {
            this.isSurfaceAvailable = false;
            this.isStartRunning = false;
            Decoder decoder = this.decoder;
            if (decoder != null) {
                decoder.destroy();
            }
            AudioPlayer audioPlayer = this.audioPlayer;
            if (audioPlayer == null) break block1;
            audioPlayer.destroy();
        }
    }

    public final void onSurfaceTextureAvailable(int width, int height) {
        this.isSurfaceAvailable = true;
        Runnable runnable = this.startRunnable;
        if (runnable != null) {
            runnable.run();
        }
        this.startRunnable = null;
    }

    public final void onSurfaceTextureSizeChanged(int width, int height) {
        block0: {
            Decoder decoder = this.decoder;
            if (decoder == null) break block0;
            decoder.onSurfaceSizeChanged(width, height);
        }
    }

    public final void startPlay(@NotNull IFileContainer fileContainer) {
        block4: {
            Object object;
            Intrinsics.checkParameterIsNotNull((Object)fileContainer, (String)"fileContainer");
            this.isStartRunning = true;
            this.prepareDecoder();
            Decoder decoder = this.decoder;
            if (decoder != null) {
                if (!decoder.prepareThread()) {
                    this.isStartRunning = false;
                    Decoder decoder2 = this.decoder;
                    if (decoder2 != null) {
                        decoder2.onFailed(10003, "0x3 thread create fail");
                    }
                    Decoder decoder3 = this.decoder;
                    if (decoder3 != null) {
                        decoder3.onVideoComplete();
                    }
                    return;
                }
            }
            if ((object = this.decoder) == null || (object = ((Decoder)object).getRenderThread()) == null || (object = ((HandlerHolder)object).getHandler()) == null) break block4;
            object.post(new Runnable(this, fileContainer){
                final /* synthetic */ AnimPlayer this$0;
                final /* synthetic */ IFileContainer $fileContainer;

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final void run() {
                    block3: {
                        block4: {
                            int result = this.this$0.getConfigManager().parseConfig(this.$fileContainer, this.this$0.getEnableVersion1(), this.this$0.getVideoMode(), this.this$0.getDefaultFps());
                            if (result != 0) {
                                this.this$0.setStartRunning(false);
                                Decoder decoder = this.this$0.getDecoder();
                                if (decoder != null) {
                                    decoder.onFailed(result, Constant.getErrorMsg$default(Constant.INSTANCE, result, null, 2, null));
                                }
                                Decoder decoder2 = this.this$0.getDecoder();
                                if (decoder2 == null) return;
                                decoder2.onVideoComplete();
                                return;
                            }
                            ALog.INSTANCE.i("AnimPlayer.AnimPlayer", "parse " + this.this$0.getConfigManager().getConfig());
                            AnimConfig config = this.this$0.getConfigManager().getConfig();
                            if (config == null) break block3;
                            if (config.isDefaultConfig()) break block4;
                            IAnimListener iAnimListener = this.this$0.getAnimListener();
                            if (iAnimListener == null) break block3;
                            if (!iAnimListener.onVideoConfigReady(config)) break block3;
                        }
                        AnimPlayer.access$innerStartPlay(this.this$0, this.$fileContainer);
                        return;
                    }
                    ALog.INSTANCE.i("AnimPlayer.AnimPlayer", "onVideoConfigReady return false");
                }
                {
                    this.this$0 = animPlayer;
                    this.$fileContainer = iFileContainer;
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void innerStartPlay(IFileContainer fileContainer) {
        Class<AnimPlayer> clazz = AnimPlayer.class;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (clazz) {
            boolean bl3 = false;
            if (this.isSurfaceAvailable) {
                this.isStartRunning = false;
                Decoder decoder = this.decoder;
                if (decoder != null) {
                    decoder.start(fileContainer);
                }
                if (!this.isMute) {
                    AudioPlayer audioPlayer = this.audioPlayer;
                    if (audioPlayer != null) {
                        audioPlayer.start(fileContainer);
                    }
                }
            } else {
                this.startRunnable = new Runnable(this, fileContainer){
                    final /* synthetic */ AnimPlayer this$0;
                    final /* synthetic */ IFileContainer $fileContainer$inlined;
                    {
                        this.this$0 = animPlayer;
                        this.$fileContainer$inlined = iFileContainer;
                    }

                    public final void run() {
                        AnimPlayer.access$innerStartPlay(this.this$0, this.$fileContainer$inlined);
                    }
                };
                this.animView.prepareTextureView();
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    public final void stopPlay() {
        block1: {
            Decoder decoder = this.decoder;
            if (decoder != null) {
                decoder.stop();
            }
            AudioPlayer audioPlayer = this.audioPlayer;
            if (audioPlayer == null) break block1;
            audioPlayer.stop();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isRunning() {
        if (this.isStartRunning) return true;
        Decoder decoder = this.decoder;
        if (decoder == null) return false;
        boolean bl = decoder.isRunning();
        if (!bl) return false;
        return true;
    }

    private final void prepareDecoder() {
        Object object;
        Object $this$apply;
        boolean bl;
        boolean bl2;
        AnimPlayer animPlayer;
        Object object2;
        if (this.decoder == null) {
            object2 = new HardDecoder(this);
            animPlayer = this;
            bl2 = false;
            bl = false;
            $this$apply = object2;
            boolean bl3 = false;
            ((Decoder)$this$apply).setPlayLoop(this.playLoop);
            ((Decoder)$this$apply).setFps(this.fps);
            object = object2;
            animPlayer.decoder = (Decoder)object;
        }
        if (this.audioPlayer == null) {
            object2 = new AudioPlayer(this);
            animPlayer = this;
            bl2 = false;
            bl = false;
            $this$apply = object2;
            boolean bl4 = false;
            ((AudioPlayer)$this$apply).setPlayLoop(this.playLoop);
            animPlayer.audioPlayer = object = object2;
        }
    }

    public final void updateMaskConfig(@Nullable MaskConfig maskConfig) {
        block4: {
            Object object;
            Object object2;
            Object object3;
            AnimConfig animConfig = this.configManager.getConfig();
            if (animConfig != null) {
                Object object4 = this.configManager.getConfig();
                if (object4 == null || (object4 = ((AnimConfig)object4).getMaskConfig()) == null) {
                    object4 = new MaskConfig();
                }
                animConfig.setMaskConfig((MaskConfig)object4);
            }
            if ((object3 = this.configManager.getConfig()) != null && (object3 = ((AnimConfig)object3).getMaskConfig()) != null) {
                MaskConfig maskConfig2 = maskConfig;
                ((MaskConfig)object3).safeSetMaskBitmapAndReleasePre((Bitmap)(maskConfig2 != null ? maskConfig2.getAlphaMaskBitmap() : null));
            }
            if ((object2 = this.configManager.getConfig()) != null && (object2 = ((AnimConfig)object2).getMaskConfig()) != null) {
                MaskConfig maskConfig3 = maskConfig;
                ((MaskConfig)object2).setMaskPositionPair((Pair<PointRect, RefVec2>)(maskConfig3 != null ? maskConfig3.getMaskPositionPair() : null));
            }
            if ((object = this.configManager.getConfig()) == null || (object = ((AnimConfig)object).getMaskConfig()) == null) break block4;
            MaskConfig maskConfig4 = maskConfig;
            ((MaskConfig)object).setMaskTexPair((Pair<PointRect, RefVec2>)(maskConfig4 != null ? maskConfig4.getMaskTexPair() : null));
        }
    }

    @NotNull
    public final IAnimView getAnimView() {
        return this.animView;
    }

    public AnimPlayer(@NotNull IAnimView animView) {
        Intrinsics.checkParameterIsNotNull((Object)animView, (String)"animView");
        this.animView = animView;
        this.videoMode = 1;
        this.configManager = new AnimConfigManager(this);
        this.pluginManager = new AnimPluginManager(this);
    }

    public static final /* synthetic */ void access$innerStartPlay(AnimPlayer $this, IFileContainer fileContainer) {
        $this.innerStartPlay(fileContainer);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/tencent/qgame/animplayer/AnimPlayer$Companion;", "", "()V", "TAG", "", "animplayer_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

