/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qgame.animplayer;

import android.graphics.SurfaceTexture;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import com.tencent.qgame.animplayer.AnimConfig;
import com.tencent.qgame.animplayer.AnimPlayer;
import com.tencent.qgame.animplayer.Decoder;
import com.tencent.qgame.animplayer.HandlerHolder;
import com.tencent.qgame.animplayer.IRenderListener;
import com.tencent.qgame.animplayer.Render;
import com.tencent.qgame.animplayer.YUVRender;
import com.tencent.qgame.animplayer.file.IFileContainer;
import com.tencent.qgame.animplayer.inter.IAnimListener;
import com.tencent.qgame.animplayer.util.ALog;
import com.tencent.qgame.animplayer.util.SpeedControlUtil;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u0000 J2\u00020\u0001:\u0001JB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010,\u001a\u00020-H&J\u0006\u0010.\u001a\u00020-J\u001a\u0010/\u001a\u00020-2\u0006\u00100\u001a\u00020\n2\b\u00101\u001a\u0004\u0018\u000102H\u0016J\u0016\u00103\u001a\u00020-2\u0006\u00104\u001a\u00020\n2\u0006\u00105\u001a\u00020\nJ\b\u00106\u001a\u00020-H\u0016J\b\u00107\u001a\u00020-H\u0016J\u001a\u00108\u001a\u00020-2\u0006\u00109\u001a\u00020\n2\b\u0010:\u001a\u0004\u0018\u00010;H\u0016J\b\u0010<\u001a\u00020-H\u0016J\u0016\u0010=\u001a\u00020-2\u0006\u0010>\u001a\u00020\n2\u0006\u0010?\u001a\u00020\nJ\u000e\u0010@\u001a\u00020\u00112\u0006\u0010A\u001a\u00020\u0011J\u0006\u0010B\u001a\u00020\u0011J\u0010\u0010C\u001a\u00020-2\u0006\u0010D\u001a\u00020EH&J\u0006\u0010F\u001a\u00020-J\u0016\u0010G\u001a\u00020-2\u0006\u0010H\u001a\u00020\n2\u0006\u0010I\u001a\u00020\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR$\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0012\"\u0004\b\u0016\u0010\u0014R\u001a\u0010\u0017\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\r\"\u0004\b\u0019\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u001c\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u0011\u0010\"\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\bR\u001b\u0010$\u001a\u00020%8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b(\u0010)\u001a\u0004\b&\u0010'R\u000e\u0010*\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006K"}, d2={"Lcom/tencent/qgame/animplayer/Decoder;", "Lcom/tencent/qgame/animplayer/inter/IAnimListener;", "player", "Lcom/tencent/qgame/animplayer/AnimPlayer;", "(Lcom/tencent/qgame/animplayer/AnimPlayer;)V", "decodeThread", "Lcom/tencent/qgame/animplayer/HandlerHolder;", "getDecodeThread", "()Lcom/tencent/qgame/animplayer/HandlerHolder;", "value", "", "fps", "getFps", "()I", "setFps", "(I)V", "isRunning", "", "()Z", "setRunning", "(Z)V", "isStopReq", "setStopReq", "playLoop", "getPlayLoop", "setPlayLoop", "getPlayer", "()Lcom/tencent/qgame/animplayer/AnimPlayer;", "render", "Lcom/tencent/qgame/animplayer/IRenderListener;", "getRender", "()Lcom/tencent/qgame/animplayer/IRenderListener;", "setRender", "(Lcom/tencent/qgame/animplayer/IRenderListener;)V", "renderThread", "getRenderThread", "speedControlUtil", "Lcom/tencent/qgame/animplayer/util/SpeedControlUtil;", "getSpeedControlUtil", "()Lcom/tencent/qgame/animplayer/util/SpeedControlUtil;", "speedControlUtil$delegate", "Lkotlin/Lazy;", "surfaceHeight", "surfaceWidth", "destroy", "", "destroyThread", "onFailed", "errorType", "errorMsg", "", "onSurfaceSizeChanged", "width", "height", "onVideoComplete", "onVideoDestroy", "onVideoRender", "frameIndex", "config", "Lcom/tencent/qgame/animplayer/AnimConfig;", "onVideoStart", "preparePlay", "videoWidth", "videoHeight", "prepareRender", "needYUV", "prepareThread", "start", "fileContainer", "Lcom/tencent/qgame/animplayer/file/IFileContainer;", "stop", "videoSizeChange", "newWidth", "newHeight", "Companion", "animplayer_release"})
public abstract class Decoder
implements IAnimListener {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    @Nullable
    private IRenderListener render;
    @NotNull
    private final HandlerHolder renderThread;
    @NotNull
    private final HandlerHolder decodeThread;
    private int surfaceWidth;
    private int surfaceHeight;
    private int fps;
    private int playLoop;
    private boolean isRunning;
    private boolean isStopReq;
    @NotNull
    private final Lazy speedControlUtil$delegate;
    @NotNull
    private final AnimPlayer player;
    private static final String TAG = "AnimPlayer.Decoder";
    public static final Companion Companion;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(Decoder.class), "speedControlUtil", "getSpeedControlUtil()Lcom/tencent/qgame/animplayer/util/SpeedControlUtil;"))};
        Companion = new Companion(null);
    }

    @Nullable
    public final IRenderListener getRender() {
        return this.render;
    }

    public final void setRender(@Nullable IRenderListener iRenderListener) {
        this.render = iRenderListener;
    }

    @NotNull
    public final HandlerHolder getRenderThread() {
        return this.renderThread;
    }

    @NotNull
    public final HandlerHolder getDecodeThread() {
        return this.decodeThread;
    }

    public final int getFps() {
        return this.fps;
    }

    public final void setFps(int value) {
        this.getSpeedControlUtil().setFixedPlaybackRate(value);
        this.fps = value;
    }

    public final int getPlayLoop() {
        return this.playLoop;
    }

    public final void setPlayLoop(int n) {
        this.playLoop = n;
    }

    public final boolean isRunning() {
        return this.isRunning;
    }

    public final void setRunning(boolean bl) {
        this.isRunning = bl;
    }

    public final boolean isStopReq() {
        return this.isStopReq;
    }

    public final void setStopReq(boolean bl) {
        this.isStopReq = bl;
    }

    @NotNull
    public final SpeedControlUtil getSpeedControlUtil() {
        Lazy lazy = this.speedControlUtil$delegate;
        Decoder decoder = this;
        KProperty kProperty = $$delegatedProperties[0];
        boolean bl = false;
        return (SpeedControlUtil)lazy.getValue();
    }

    public abstract void start(@NotNull IFileContainer var1);

    public final void stop() {
        this.isStopReq = true;
    }

    public abstract void destroy();

    public final boolean prepareThread() {
        return Companion.createThread(this.renderThread, "anim_render_thread") && Companion.createThread(this.decodeThread, "anim_decode_thread");
    }

    public final boolean prepareRender(boolean needYUV) {
        block3: {
            if (this.render != null) break block3;
            ALog.INSTANCE.i(TAG, "prepareRender");
            SurfaceTexture surfaceTexture = this.player.getAnimView().getSurfaceTexture();
            if (surfaceTexture != null) {
                SurfaceTexture surfaceTexture2 = surfaceTexture;
                boolean bl = false;
                boolean bl2 = false;
                SurfaceTexture $this$apply = surfaceTexture2;
                boolean bl3 = false;
                if (needYUV) {
                    ALog.INSTANCE.i(TAG, "use yuv render");
                    this.render = new YUVRender($this$apply);
                } else {
                    Render render = new Render($this$apply);
                    Decoder decoder = this;
                    boolean bl4 = false;
                    boolean bl5 = false;
                    Render $this$apply2 = render;
                    boolean bl6 = false;
                    $this$apply2.updateViewPort(this.surfaceWidth, this.surfaceHeight);
                    Render render2 = render;
                    decoder.render = render2;
                }
            }
        }
        return this.render != null;
    }

    public final void preparePlay(int videoWidth, int videoHeight) {
        this.player.getConfigManager().defaultConfig(videoWidth, videoHeight);
        AnimConfig animConfig = this.player.getConfigManager().getConfig();
        if (animConfig != null) {
            AnimConfig animConfig2 = animConfig;
            boolean bl = false;
            boolean bl2 = false;
            AnimConfig $this$apply = animConfig2;
            boolean bl3 = false;
            IRenderListener iRenderListener = this.render;
            if (iRenderListener != null) {
                iRenderListener.setAnimConfig($this$apply);
            }
        }
        this.player.getPluginManager().onRenderCreate();
    }

    public final void videoSizeChange(int newWidth, int newHeight) {
        block3: {
            if (newWidth <= 0 || newHeight <= 0) {
                return;
            }
            AnimConfig animConfig = this.player.getConfigManager().getConfig();
            if (animConfig == null) {
                return;
            }
            AnimConfig config = animConfig;
            if (config.getVideoWidth() == newWidth && config.getVideoHeight() == newHeight) break block3;
            ALog.INSTANCE.i(TAG, "videoSizeChange old=(" + config.getVideoWidth() + ',' + config.getVideoHeight() + "), new=(" + newWidth + ',' + newHeight + ')');
            config.setVideoWidth(newWidth);
            config.setVideoHeight(newHeight);
            IRenderListener iRenderListener = this.render;
            if (iRenderListener != null) {
                iRenderListener.setAnimConfig(config);
            }
        }
    }

    public final void destroyThread() {
        if (this.player.isDetachedFromWindow()) {
            ALog.INSTANCE.i(TAG, "destroyThread");
            Handler handler = this.renderThread.getHandler();
            if (handler != null) {
                handler.removeCallbacksAndMessages(null);
            }
            Handler handler2 = this.decodeThread.getHandler();
            if (handler2 != null) {
                handler2.removeCallbacksAndMessages(null);
            }
            this.renderThread.setThread(Companion.quitSafely(this.renderThread.getThread()));
            this.decodeThread.setThread(Companion.quitSafely(this.decodeThread.getThread()));
            this.renderThread.setHandler(null);
            this.decodeThread.setHandler(null);
        }
    }

    public final void onSurfaceSizeChanged(int width, int height) {
        block0: {
            this.surfaceWidth = width;
            this.surfaceHeight = height;
            IRenderListener iRenderListener = this.render;
            if (iRenderListener == null) break block0;
            iRenderListener.updateViewPort(width, height);
        }
    }

    @Override
    public void onVideoStart() {
        block0: {
            ALog.INSTANCE.i(TAG, "onVideoStart");
            IAnimListener iAnimListener = this.player.getAnimListener();
            if (iAnimListener == null) break block0;
            iAnimListener.onVideoStart();
        }
    }

    @Override
    public void onVideoRender(int frameIndex, @Nullable AnimConfig config) {
        block0: {
            ALog.INSTANCE.d(TAG, "onVideoRender");
            IAnimListener iAnimListener = this.player.getAnimListener();
            if (iAnimListener == null) break block0;
            iAnimListener.onVideoRender(frameIndex, config);
        }
    }

    @Override
    public void onVideoComplete() {
        block0: {
            ALog.INSTANCE.i(TAG, "onVideoComplete");
            IAnimListener iAnimListener = this.player.getAnimListener();
            if (iAnimListener == null) break block0;
            iAnimListener.onVideoComplete();
        }
    }

    @Override
    public void onVideoDestroy() {
        block0: {
            ALog.INSTANCE.i(TAG, "onVideoDestroy");
            IAnimListener iAnimListener = this.player.getAnimListener();
            if (iAnimListener == null) break block0;
            iAnimListener.onVideoDestroy();
        }
    }

    @Override
    public void onFailed(int errorType, @Nullable String errorMsg) {
        block0: {
            ALog.INSTANCE.e(TAG, "onFailed errorType=" + errorType + ", errorMsg=" + errorMsg);
            IAnimListener iAnimListener = this.player.getAnimListener();
            if (iAnimListener == null) break block0;
            iAnimListener.onFailed(errorType, errorMsg);
        }
    }

    @NotNull
    public final AnimPlayer getPlayer() {
        return this.player;
    }

    public Decoder(@NotNull AnimPlayer player) {
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        this.player = player;
        this.renderThread = new HandlerHolder(null, null);
        this.decodeThread = new HandlerHolder(null, null);
        this.speedControlUtil$delegate = LazyKt.lazy((Function0)speedControlUtil.2.INSTANCE);
    }

    @Override
    public boolean onVideoConfigReady(@NotNull AnimConfig config) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        return IAnimListener.DefaultImpls.onVideoConfigReady(this, config);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/tencent/qgame/animplayer/Decoder$Companion;", "", "()V", "TAG", "", "createThread", "", "handlerHolder", "Lcom/tencent/qgame/animplayer/HandlerHolder;", "name", "quitSafely", "Landroid/os/HandlerThread;", "thread", "animplayer_release"})
    public static final class Companion {
        public final boolean createThread(@NotNull HandlerHolder handlerHolder, @NotNull String name) {
            Intrinsics.checkParameterIsNotNull((Object)handlerHolder, (String)"handlerHolder");
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            try {
                block4: {
                    block3: {
                        if (handlerHolder.getThread() == null) break block3;
                        HandlerThread handlerThread = handlerHolder.getThread();
                        if (handlerThread == null) break block4;
                        if (handlerThread.isAlive()) break block4;
                    }
                    HandlerThread handlerThread = new HandlerThread(name);
                    HandlerHolder handlerHolder2 = handlerHolder;
                    boolean bl = false;
                    boolean bl2 = false;
                    HandlerThread $this$apply = handlerThread;
                    boolean bl3 = false;
                    $this$apply.start();
                    handlerHolder.setHandler(new Handler($this$apply.getLooper()));
                    HandlerThread handlerThread2 = handlerThread;
                    handlerHolder2.setThread(handlerThread2);
                }
                return true;
            }
            catch (OutOfMemoryError e) {
                ALog.INSTANCE.e(Decoder.TAG, "createThread OOM", e);
                return false;
            }
        }

        @Nullable
        public final HandlerThread quitSafely(@Nullable HandlerThread thread) {
            block2: {
                HandlerThread handlerThread = thread;
                if (handlerThread == null) break block2;
                HandlerThread handlerThread2 = handlerThread;
                boolean bl = false;
                boolean bl2 = false;
                HandlerThread $this$apply = handlerThread2;
                boolean bl3 = false;
                if (Build.VERSION.SDK_INT >= 18) {
                    thread.quitSafely();
                } else {
                    thread.quit();
                }
            }
            return null;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

