/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qgame.animplayer;

import android.graphics.SurfaceTexture;
import android.opengl.GLES20;
import com.tencent.qgame.animplayer.AnimConfig;
import com.tencent.qgame.animplayer.EGLUtil;
import com.tencent.qgame.animplayer.IRenderListener;
import com.tencent.qgame.animplayer.PointRect;
import com.tencent.qgame.animplayer.util.GlFloatArray;
import com.tencent.qgame.animplayer.util.ShaderUtil;
import com.tencent.qgame.animplayer.util.TexCoordsUtil;
import com.tencent.qgame.animplayer.util.VertexUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 (2\u00020\u0001:\u0001(B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u0018H\u0016J\b\u0010\u001a\u001a\u00020\u0018H\u0002J\b\u0010\u001b\u001a\u00020\u0006H\u0016J\b\u0010\u001c\u001a\u00020\u0018H\u0016J\b\u0010\u001d\u001a\u00020\u0018H\u0016J\b\u0010\u001e\u001a\u00020\u0018H\u0016J\u0010\u0010\u001f\u001a\u00020\u00182\u0006\u0010 \u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020\u00182\u0006\u0010 \u001a\u00020!H\u0002J\u0010\u0010#\u001a\u00020\u00182\u0006\u0010 \u001a\u00020!H\u0002J\b\u0010$\u001a\u00020\u0018H\u0016J\u0018\u0010%\u001a\u00020\u00182\u0006\u0010&\u001a\u00020\u00062\u0006\u0010'\u001a\u00020\u0006H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/tencent/qgame/animplayer/Render;", "Lcom/tencent/qgame/animplayer/IRenderListener;", "surfaceTexture", "Landroid/graphics/SurfaceTexture;", "(Landroid/graphics/SurfaceTexture;)V", "aPositionLocation", "", "aTextureAlphaLocation", "aTextureRgbLocation", "alphaArray", "Lcom/tencent/qgame/animplayer/util/GlFloatArray;", "eglUtil", "Lcom/tencent/qgame/animplayer/EGLUtil;", "genTexture", "", "rgbArray", "shaderProgram", "surfaceHeight", "surfaceSizeChanged", "", "surfaceWidth", "uTextureLocation", "vertexArray", "clearFrame", "", "destroyRender", "draw", "getExternalTexture", "initRender", "releaseTexture", "renderFrame", "setAnimConfig", "config", "Lcom/tencent/qgame/animplayer/AnimConfig;", "setTexCoords", "setVertexBuf", "swapBuffers", "updateViewPort", "width", "height", "Companion", "animplayer_release"})
public final class Render
implements IRenderListener {
    private final GlFloatArray vertexArray;
    private final GlFloatArray alphaArray;
    private final GlFloatArray rgbArray;
    private boolean surfaceSizeChanged;
    private int surfaceWidth;
    private int surfaceHeight;
    private final EGLUtil eglUtil;
    private int shaderProgram;
    private int[] genTexture;
    private int uTextureLocation;
    private int aPositionLocation;
    private int aTextureAlphaLocation;
    private int aTextureRgbLocation;
    private static final String TAG = "AnimPlayer.Render";
    public static final Companion Companion = new Companion(null);

    private final void setVertexBuf(AnimConfig config) {
        this.vertexArray.setArray(VertexUtil.INSTANCE.create(config.getWidth(), config.getHeight(), new PointRect(0, 0, config.getWidth(), config.getHeight()), this.vertexArray.getArray()));
    }

    private final void setTexCoords(AnimConfig config) {
        float[] alpha = TexCoordsUtil.INSTANCE.create(config.getVideoWidth(), config.getVideoHeight(), config.getAlphaPointRect(), this.alphaArray.getArray());
        float[] rgb = TexCoordsUtil.INSTANCE.create(config.getVideoWidth(), config.getVideoHeight(), config.getRgbPointRect(), this.rgbArray.getArray());
        this.alphaArray.setArray(alpha);
        this.rgbArray.setArray(rgb);
    }

    @Override
    public void initRender() {
        this.shaderProgram = ShaderUtil.INSTANCE.createProgram("attribute vec4 vPosition;\nattribute vec4 vTexCoordinateAlpha;\nattribute vec4 vTexCoordinateRgb;\nvarying vec2 v_TexCoordinateAlpha;\nvarying vec2 v_TexCoordinateRgb;\n\nvoid main() {\n    v_TexCoordinateAlpha = vec2(vTexCoordinateAlpha.x, vTexCoordinateAlpha.y);\n    v_TexCoordinateRgb = vec2(vTexCoordinateRgb.x, vTexCoordinateRgb.y);\n    gl_Position = vPosition;\n}", "#extension GL_OES_EGL_image_external : require\nprecision mediump float;\nuniform samplerExternalOES texture;\nvarying vec2 v_TexCoordinateAlpha;\nvarying vec2 v_TexCoordinateRgb;\n\nvoid main () {\n    vec4 alphaColor = texture2D(texture, v_TexCoordinateAlpha);\n    vec4 rgbColor = texture2D(texture, v_TexCoordinateRgb);\n    gl_FragColor = vec4(rgbColor.r, rgbColor.g, rgbColor.b, alphaColor.r);\n}");
        this.uTextureLocation = GLES20.glGetUniformLocation((int)this.shaderProgram, (String)"texture");
        this.aPositionLocation = GLES20.glGetAttribLocation((int)this.shaderProgram, (String)"vPosition");
        this.aTextureAlphaLocation = GLES20.glGetAttribLocation((int)this.shaderProgram, (String)"vTexCoordinateAlpha");
        this.aTextureRgbLocation = GLES20.glGetAttribLocation((int)this.shaderProgram, (String)"vTexCoordinateRgb");
        GLES20.glGenTextures((int)this.genTexture.length, (int[])this.genTexture, (int)0);
        GLES20.glBindTexture((int)36197, (int)this.genTexture[0]);
        GLES20.glTexParameterf((int)36197, (int)10241, (float)9728);
        GLES20.glTexParameterf((int)36197, (int)10240, (float)9729);
        GLES20.glTexParameteri((int)36197, (int)10242, (int)33071);
        GLES20.glTexParameteri((int)36197, (int)10243, (int)33071);
    }

    @Override
    public void renderFrame() {
        GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        GLES20.glClear((int)16384);
        if (this.surfaceSizeChanged && this.surfaceWidth > 0 && this.surfaceHeight > 0) {
            this.surfaceSizeChanged = false;
            GLES20.glViewport((int)0, (int)0, (int)this.surfaceWidth, (int)this.surfaceHeight);
        }
        this.draw();
    }

    @Override
    public void clearFrame() {
        GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        GLES20.glClear((int)16384);
        this.eglUtil.swapBuffers();
    }

    @Override
    public void destroyRender() {
        this.releaseTexture();
        this.eglUtil.release();
    }

    @Override
    public void releaseTexture() {
        GLES20.glDeleteTextures((int)this.genTexture.length, (int[])this.genTexture, (int)0);
    }

    @Override
    public void setAnimConfig(@NotNull AnimConfig config) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        this.setVertexBuf(config);
        this.setTexCoords(config);
    }

    @Override
    public void updateViewPort(int width, int height) {
        if (width <= 0 || height <= 0) {
            return;
        }
        this.surfaceSizeChanged = true;
        this.surfaceWidth = width;
        this.surfaceHeight = height;
    }

    @Override
    public void swapBuffers() {
        this.eglUtil.swapBuffers();
    }

    @Override
    public int getExternalTexture() {
        return this.genTexture[0];
    }

    private final void draw() {
        GLES20.glUseProgram((int)this.shaderProgram);
        this.vertexArray.setVertexAttribPointer(this.aPositionLocation);
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)36197, (int)this.genTexture[0]);
        GLES20.glUniform1i((int)this.uTextureLocation, (int)0);
        this.alphaArray.setVertexAttribPointer(this.aTextureAlphaLocation);
        this.rgbArray.setVertexAttribPointer(this.aTextureRgbLocation);
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
    }

    public Render(@NotNull SurfaceTexture surfaceTexture) {
        Intrinsics.checkParameterIsNotNull((Object)surfaceTexture, (String)"surfaceTexture");
        this.vertexArray = new GlFloatArray();
        this.alphaArray = new GlFloatArray();
        this.rgbArray = new GlFloatArray();
        this.eglUtil = new EGLUtil();
        this.genTexture = new int[1];
        this.eglUtil.start(surfaceTexture);
        this.initRender();
    }

    @Override
    public void setYUVData(int width, int height, @Nullable byte[] y, @Nullable byte[] u, @Nullable byte[] v) {
        IRenderListener.DefaultImpls.setYUVData(this, width, height, y, u, v);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/tencent/qgame/animplayer/Render$Companion;", "", "()V", "TAG", "", "animplayer_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

