/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qgame.animplayer;

import android.graphics.SurfaceTexture;
import android.opengl.GLES20;
import com.tencent.qgame.animplayer.AnimConfig;
import com.tencent.qgame.animplayer.EGLUtil;
import com.tencent.qgame.animplayer.IRenderListener;
import com.tencent.qgame.animplayer.PointRect;
import com.tencent.qgame.animplayer.util.GlFloatArray;
import com.tencent.qgame.animplayer.util.ShaderUtil;
import com.tencent.qgame.animplayer.util.TexCoordsUtil;
import com.tencent.qgame.animplayer.util.VertexUtil;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0003\u0018\u0000 12\u00020\u0001:\u00011B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020\"H\u0016J\b\u0010$\u001a\u00020\"H\u0002J\b\u0010%\u001a\u00020\u000bH\u0016J\b\u0010&\u001a\u00020\"H\u0016J\b\u0010'\u001a\u00020\"H\u0016J\b\u0010(\u001a\u00020\"H\u0016J\u0010\u0010)\u001a\u00020\"2\u0006\u0010*\u001a\u00020+H\u0016J6\u0010,\u001a\u00020\"2\u0006\u0010-\u001a\u00020\u000b2\u0006\u0010.\u001a\u00020\u000b2\b\u0010 \u001a\u0004\u0018\u00010/2\b\u0010\u001a\u001a\u0004\u0018\u00010/2\b\u0010\u001d\u001a\u0004\u0018\u00010/H\u0016J\b\u00100\u001a\u00020\"H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010 \u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/tencent/qgame/animplayer/YUVRender;", "Lcom/tencent/qgame/animplayer/IRenderListener;", "surfaceTexture", "Landroid/graphics/SurfaceTexture;", "(Landroid/graphics/SurfaceTexture;)V", "YUV_MATRIX", "", "YUV_OFFSET", "alphaArray", "Lcom/tencent/qgame/animplayer/util/GlFloatArray;", "alphaPosition", "", "avPosition", "convertMatrixUniform", "convertOffsetUniform", "eglUtil", "Lcom/tencent/qgame/animplayer/EGLUtil;", "heightYUV", "rgbArray", "rgbPosition", "samplerU", "samplerV", "samplerY", "shaderProgram", "textureId", "", "u", "Ljava/nio/ByteBuffer;", "unpackAlign", "v", "vertexArray", "widthYUV", "y", "clearFrame", "", "destroyRender", "draw", "getExternalTexture", "initRender", "releaseTexture", "renderFrame", "setAnimConfig", "config", "Lcom/tencent/qgame/animplayer/AnimConfig;", "setYUVData", "width", "height", "", "swapBuffers", "Companion", "animplayer_release"})
public final class YUVRender
implements IRenderListener {
    private final GlFloatArray vertexArray;
    private final GlFloatArray alphaArray;
    private final GlFloatArray rgbArray;
    private int shaderProgram;
    private int avPosition;
    private int rgbPosition;
    private int alphaPosition;
    private int samplerY;
    private int samplerU;
    private int samplerV;
    private int[] textureId;
    private int convertMatrixUniform;
    private int convertOffsetUniform;
    private int widthYUV;
    private int heightYUV;
    private ByteBuffer y;
    private ByteBuffer u;
    private ByteBuffer v;
    private final EGLUtil eglUtil;
    private int unpackAlign;
    private final float[] YUV_OFFSET;
    private final float[] YUV_MATRIX;
    private static final String TAG = "AnimPlayer.YUVRender";
    public static final Companion Companion = new Companion(null);

    @Override
    public void initRender() {
        this.shaderProgram = ShaderUtil.INSTANCE.createProgram("attribute vec4 v_Position;\nattribute vec2 vTexCoordinateAlpha;\nattribute vec2 vTexCoordinateRgb;\nvarying vec2 v_TexCoordinateAlpha;\nvarying vec2 v_TexCoordinateRgb;\n\nvoid main() {\n    v_TexCoordinateAlpha = vTexCoordinateAlpha;\n    v_TexCoordinateRgb = vTexCoordinateRgb;\n    gl_Position = v_Position;\n}", "precision mediump float;\nuniform sampler2D sampler_y;\nuniform sampler2D sampler_u;\nuniform sampler2D sampler_v;\nvarying vec2 v_TexCoordinateAlpha;\nvarying vec2 v_TexCoordinateRgb;\nuniform mat3 convertMatrix;\nuniform vec3 offset;\n\nvoid main() {\n   highp vec3 yuvColorAlpha;\n   highp vec3 yuvColorRGB;\n   highp vec3 rgbColorAlpha;\n   highp vec3 rgbColorRGB;\n   yuvColorAlpha.x = texture2D(sampler_y,v_TexCoordinateAlpha).r;\n   yuvColorRGB.x = texture2D(sampler_y,v_TexCoordinateRgb).r;\n   yuvColorAlpha.y = texture2D(sampler_u,v_TexCoordinateAlpha).r;\n   yuvColorAlpha.z = texture2D(sampler_v,v_TexCoordinateAlpha).r;\n   yuvColorRGB.y = texture2D(sampler_u,v_TexCoordinateRgb).r;\n   yuvColorRGB.z = texture2D(sampler_v,v_TexCoordinateRgb).r;\n   yuvColorAlpha += offset;\n   yuvColorRGB += offset;\n   rgbColorAlpha = convertMatrix * yuvColorAlpha; \n   rgbColorRGB = convertMatrix * yuvColorRGB; \n   gl_FragColor=vec4(rgbColorRGB, rgbColorAlpha.r);\n}");
        this.avPosition = GLES20.glGetAttribLocation((int)this.shaderProgram, (String)"v_Position");
        this.rgbPosition = GLES20.glGetAttribLocation((int)this.shaderProgram, (String)"vTexCoordinateRgb");
        this.alphaPosition = GLES20.glGetAttribLocation((int)this.shaderProgram, (String)"vTexCoordinateAlpha");
        this.samplerY = GLES20.glGetUniformLocation((int)this.shaderProgram, (String)"sampler_y");
        this.samplerU = GLES20.glGetUniformLocation((int)this.shaderProgram, (String)"sampler_u");
        this.samplerV = GLES20.glGetUniformLocation((int)this.shaderProgram, (String)"sampler_v");
        this.convertMatrixUniform = GLES20.glGetUniformLocation((int)this.shaderProgram, (String)"convertMatrix");
        this.convertOffsetUniform = GLES20.glGetUniformLocation((int)this.shaderProgram, (String)"offset");
        GLES20.glGenTextures((int)this.textureId.length, (int[])this.textureId, (int)0);
        for (int id : this.textureId) {
            GLES20.glBindTexture((int)3553, (int)id);
            GLES20.glTexParameteri((int)3553, (int)10242, (int)10497);
            GLES20.glTexParameteri((int)3553, (int)10243, (int)10497);
            GLES20.glTexParameteri((int)3553, (int)10241, (int)9729);
            GLES20.glTexParameteri((int)3553, (int)10240, (int)9729);
        }
    }

    @Override
    public void renderFrame() {
        GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        GLES20.glClear((int)16384);
        this.draw();
    }

    @Override
    public void clearFrame() {
        GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        GLES20.glClear((int)16384);
        this.eglUtil.swapBuffers();
    }

    @Override
    public void destroyRender() {
        this.releaseTexture();
        this.eglUtil.release();
    }

    @Override
    public void setAnimConfig(@NotNull AnimConfig config) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        this.vertexArray.setArray(VertexUtil.INSTANCE.create(config.getWidth(), config.getHeight(), new PointRect(0, 0, config.getWidth(), config.getHeight()), this.vertexArray.getArray()));
        float[] alpha = TexCoordsUtil.INSTANCE.create(config.getVideoWidth(), config.getVideoHeight(), config.getAlphaPointRect(), this.alphaArray.getArray());
        float[] rgb = TexCoordsUtil.INSTANCE.create(config.getVideoWidth(), config.getVideoHeight(), config.getRgbPointRect(), this.rgbArray.getArray());
        this.alphaArray.setArray(alpha);
        this.rgbArray.setArray(rgb);
    }

    @Override
    public int getExternalTexture() {
        return this.textureId[0];
    }

    @Override
    public void releaseTexture() {
        GLES20.glDeleteTextures((int)this.textureId.length, (int[])this.textureId, (int)0);
    }

    @Override
    public void swapBuffers() {
        this.eglUtil.swapBuffers();
    }

    @Override
    public void setYUVData(int width, int height, @Nullable byte[] y, @Nullable byte[] u, @Nullable byte[] v) {
        this.widthYUV = width;
        this.heightYUV = height;
        this.y = ByteBuffer.wrap(y);
        this.u = ByteBuffer.wrap(u);
        this.v = ByteBuffer.wrap(v);
        if (this.widthYUV / 2 % 4 != 0) {
            this.unpackAlign = this.widthYUV / 2 % 2 == 0 ? 2 : 1;
        }
    }

    private final void draw() {
        if (this.widthYUV > 0 && this.heightYUV > 0 && this.y != null && this.u != null && this.v != null) {
            GLES20.glUseProgram((int)this.shaderProgram);
            this.vertexArray.setVertexAttribPointer(this.avPosition);
            this.alphaArray.setVertexAttribPointer(this.alphaPosition);
            this.rgbArray.setVertexAttribPointer(this.rgbPosition);
            GLES20.glPixelStorei((int)3317, (int)this.unpackAlign);
            GLES20.glActiveTexture((int)33984);
            GLES20.glBindTexture((int)3553, (int)this.textureId[0]);
            GLES20.glTexImage2D((int)3553, (int)0, (int)6409, (int)this.widthYUV, (int)this.heightYUV, (int)0, (int)6409, (int)5121, (Buffer)this.y);
            GLES20.glActiveTexture((int)33985);
            GLES20.glBindTexture((int)3553, (int)this.textureId[1]);
            GLES20.glTexImage2D((int)3553, (int)0, (int)6409, (int)(this.widthYUV / 2), (int)(this.heightYUV / 2), (int)0, (int)6409, (int)5121, (Buffer)this.u);
            GLES20.glActiveTexture((int)33986);
            GLES20.glBindTexture((int)3553, (int)this.textureId[2]);
            GLES20.glTexImage2D((int)3553, (int)0, (int)6409, (int)(this.widthYUV / 2), (int)(this.heightYUV / 2), (int)0, (int)6409, (int)5121, (Buffer)this.v);
            GLES20.glUniform1i((int)this.samplerY, (int)0);
            GLES20.glUniform1i((int)this.samplerU, (int)1);
            GLES20.glUniform1i((int)this.samplerV, (int)2);
            GLES20.glUniform3fv((int)this.convertOffsetUniform, (int)1, (FloatBuffer)FloatBuffer.wrap(this.YUV_OFFSET));
            GLES20.glUniformMatrix3fv((int)this.convertMatrixUniform, (int)1, (boolean)false, (float[])this.YUV_MATRIX, (int)0);
            GLES20.glDrawArrays((int)5, (int)0, (int)4);
            ByteBuffer byteBuffer = this.y;
            if (byteBuffer != null) {
                byteBuffer.clear();
            }
            ByteBuffer byteBuffer2 = this.u;
            if (byteBuffer2 != null) {
                byteBuffer2.clear();
            }
            ByteBuffer byteBuffer3 = this.v;
            if (byteBuffer3 != null) {
                byteBuffer3.clear();
            }
            this.y = null;
            this.u = null;
            this.v = null;
            GLES20.glDisableVertexAttribArray((int)this.avPosition);
            GLES20.glDisableVertexAttribArray((int)this.rgbPosition);
            GLES20.glDisableVertexAttribArray((int)this.alphaPosition);
        }
    }

    public YUVRender(@NotNull SurfaceTexture surfaceTexture) {
        Intrinsics.checkParameterIsNotNull((Object)surfaceTexture, (String)"surfaceTexture");
        this.vertexArray = new GlFloatArray();
        this.alphaArray = new GlFloatArray();
        this.rgbArray = new GlFloatArray();
        this.textureId = new int[3];
        this.eglUtil = new EGLUtil();
        this.unpackAlign = 4;
        this.YUV_OFFSET = new float[]{0.0f, -0.5019608f, -0.5019608f};
        this.YUV_MATRIX = new float[]{1.0f, 1.0f, 1.0f, 0.0f, -0.3441f, 1.772f, 1.402f, -0.7141f, 0.0f};
        this.eglUtil.start(surfaceTexture);
        this.initRender();
    }

    @Override
    public void updateViewPort(int width, int height) {
        IRenderListener.DefaultImpls.updateViewPort(this, width, height);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/tencent/qgame/animplayer/YUVRender$Companion;", "", "()V", "TAG", "", "animplayer_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

