/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qgame.animplayer.mix;

import android.opengl.GLES20;
import com.tencent.qgame.animplayer.AnimConfig;
import com.tencent.qgame.animplayer.Decoder;
import com.tencent.qgame.animplayer.PointRect;
import com.tencent.qgame.animplayer.mix.Frame;
import com.tencent.qgame.animplayer.mix.MixAnimPlugin;
import com.tencent.qgame.animplayer.mix.MixShader;
import com.tencent.qgame.animplayer.mix.Src;
import com.tencent.qgame.animplayer.mix.SrcMap;
import com.tencent.qgame.animplayer.util.ALog;
import com.tencent.qgame.animplayer.util.GlFloatArray;
import com.tencent.qgame.animplayer.util.TexCoordsUtil;
import com.tencent.qgame.animplayer.util.TextureLoadUtil;
import com.tencent.qgame.animplayer.util.VertexUtil;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 .2\u00020\u0001:\u0001.B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J8\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0006\u0010!\u001a\u00020\"J\u000e\u0010#\u001a\u00020\"2\u0006\u0010$\u001a\u00020\u001bJ\u001e\u0010%\u001a\u00020\"2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+J\u0010\u0010,\u001a\u00020\u00182\u0006\u0010-\u001a\u00020\u001bH\u0002R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\b\"\u0004\b\u0013\u0010\nR\u001a\u0010\u0014\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\b\"\u0004\b\u0016\u0010\n\u00a8\u0006/"}, d2={"Lcom/tencent/qgame/animplayer/mix/MixRender;", "", "mixAnimPlugin", "Lcom/tencent/qgame/animplayer/mix/MixAnimPlugin;", "(Lcom/tencent/qgame/animplayer/mix/MixAnimPlugin;)V", "maskArray", "Lcom/tencent/qgame/animplayer/util/GlFloatArray;", "getMaskArray", "()Lcom/tencent/qgame/animplayer/util/GlFloatArray;", "setMaskArray", "(Lcom/tencent/qgame/animplayer/util/GlFloatArray;)V", "shader", "Lcom/tencent/qgame/animplayer/mix/MixShader;", "getShader", "()Lcom/tencent/qgame/animplayer/mix/MixShader;", "setShader", "(Lcom/tencent/qgame/animplayer/mix/MixShader;)V", "srcArray", "getSrcArray", "setSrcArray", "vertexArray", "getVertexArray", "setVertexArray", "genSrcCoordsArray", "", "array", "fw", "", "fh", "sw", "sh", "fitType", "Lcom/tencent/qgame/animplayer/mix/Src$FitType;", "init", "", "release", "textureId", "renderFrame", "config", "Lcom/tencent/qgame/animplayer/AnimConfig;", "frame", "Lcom/tencent/qgame/animplayer/mix/Frame;", "src", "Lcom/tencent/qgame/animplayer/mix/Src;", "transColor", "color", "Companion", "animplayer_release"})
public final class MixRender {
    @Nullable
    private MixShader shader;
    @NotNull
    private GlFloatArray vertexArray;
    @NotNull
    private GlFloatArray srcArray;
    @NotNull
    private GlFloatArray maskArray;
    private final MixAnimPlugin mixAnimPlugin;
    private static final String TAG = "AnimPlayer.MixRender";
    public static final Companion Companion = new Companion(null);

    @Nullable
    public final MixShader getShader() {
        return this.shader;
    }

    public final void setShader(@Nullable MixShader mixShader) {
        this.shader = mixShader;
    }

    @NotNull
    public final GlFloatArray getVertexArray() {
        return this.vertexArray;
    }

    public final void setVertexArray(@NotNull GlFloatArray glFloatArray) {
        Intrinsics.checkParameterIsNotNull((Object)glFloatArray, (String)"<set-?>");
        this.vertexArray = glFloatArray;
    }

    @NotNull
    public final GlFloatArray getSrcArray() {
        return this.srcArray;
    }

    public final void setSrcArray(@NotNull GlFloatArray glFloatArray) {
        Intrinsics.checkParameterIsNotNull((Object)glFloatArray, (String)"<set-?>");
        this.srcArray = glFloatArray;
    }

    @NotNull
    public final GlFloatArray getMaskArray() {
        return this.maskArray;
    }

    public final void setMaskArray(@NotNull GlFloatArray glFloatArray) {
        Intrinsics.checkParameterIsNotNull((Object)glFloatArray, (String)"<set-?>");
        this.maskArray = glFloatArray;
    }

    public final void init() {
        this.shader = new MixShader();
        GLES20.glDisable((int)2929);
        Object object = this.mixAnimPlugin.getSrcMap();
        if (object != null && (object = ((SrcMap)object).getMap()) != null && (object = ((HashMap)object).values()) != null) {
            Iterable $this$forEach$iv = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Src src = (Src)element$iv;
                boolean bl = false;
                ALog.INSTANCE.i(TAG, "init srcId=" + src.getSrcId());
                src.setSrcTextureId(TextureLoadUtil.INSTANCE.loadTexture(src.getBitmap()));
                MixShader mixShader = this.shader;
                ALog.INSTANCE.i(TAG, "textureProgram=" + (mixShader != null ? Integer.valueOf(mixShader.getProgram()) : null) + ",textureId=" + src.getSrcTextureId());
            }
        }
    }

    public final void renderFrame(@NotNull AnimConfig config, @NotNull Frame frame, @NotNull Src src) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        Intrinsics.checkParameterIsNotNull((Object)frame, (String)"frame");
        Intrinsics.checkParameterIsNotNull((Object)src, (String)"src");
        Object object = this.mixAnimPlugin.getPlayer().getDecoder();
        if (object == null || (object = ((Decoder)object).getRender()) == null) {
            return;
        }
        int videoTextureId = object.getExternalTexture();
        if (videoTextureId <= 0) {
            return;
        }
        MixShader mixShader = this.shader;
        if (mixShader == null) {
            return;
        }
        MixShader shader = mixShader;
        shader.useProgram();
        this.vertexArray.setArray(VertexUtil.INSTANCE.create(config.getWidth(), config.getHeight(), frame.getFrame(), this.vertexArray.getArray()));
        this.vertexArray.setVertexAttribPointer(shader.getAPositionLocation());
        this.srcArray.setArray(this.genSrcCoordsArray(this.srcArray.getArray(), frame.getFrame().getW(), frame.getFrame().getH(), src.getDrawWidth(), src.getDrawHeight(), src.getFitType()));
        this.srcArray.setVertexAttribPointer(shader.getATextureSrcCoordinatesLocation());
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)3553, (int)src.getSrcTextureId());
        GLES20.glUniform1i((int)shader.getUTextureSrcUnitLocation(), (int)0);
        this.maskArray.setArray(TexCoordsUtil.INSTANCE.create(config.getVideoWidth(), config.getVideoHeight(), frame.getMFrame(), this.maskArray.getArray()));
        if (frame.getMt() == 90) {
            this.maskArray.setArray(TexCoordsUtil.INSTANCE.rotate90(this.maskArray.getArray()));
        }
        this.maskArray.setVertexAttribPointer(shader.getATextureMaskCoordinatesLocation());
        GLES20.glActiveTexture((int)33985);
        GLES20.glBindTexture((int)36197, (int)videoTextureId);
        GLES20.glUniform1i((int)shader.getUTextureMaskUnitLocation(), (int)1);
        if (src.getSrcType() == Src.SrcType.TXT && this.mixAnimPlugin.getAutoTxtColorFill()) {
            GLES20.glUniform1i((int)shader.getUIsFillLocation(), (int)1);
            float[] argb = this.transColor(src.getColor());
            GLES20.glUniform4f((int)shader.getUColorLocation(), (float)argb[1], (float)argb[2], (float)argb[3], (float)argb[0]);
        } else {
            GLES20.glUniform1i((int)shader.getUIsFillLocation(), (int)0);
            GLES20.glUniform4f((int)shader.getUColorLocation(), (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        }
        GLES20.glEnable((int)3042);
        GLES20.glBlendFuncSeparate((int)770, (int)771, (int)1, (int)771);
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        GLES20.glDisable((int)3042);
    }

    public final void release(int textureId) {
        if (textureId != 0) {
            GLES20.glDeleteTextures((int)1, (int[])new int[]{textureId}, (int)0);
        }
    }

    private final float[] genSrcCoordsArray(float[] array, int fw, int fh, int sw, int sh, Src.FitType fitType) {
        float[] fArray;
        if (fitType == Src.FitType.CENTER_FULL) {
            if (fw <= sw && fh <= sh) {
                int gw = (sw - fw) / 2;
                int gh = (sh - fh) / 2;
                fArray = TexCoordsUtil.INSTANCE.create(sw, sh, new PointRect(gw, gh, fw, fh), array);
            } else {
                PointRect pointRect;
                float fScale = (float)fw * 1.0f / (float)fh;
                float sScale = (float)sw * 1.0f / (float)sh;
                if (fScale > sScale) {
                    int w = sw;
                    int x = 0;
                    int h = (int)((float)sw / fScale);
                    int y = (sh - h) / 2;
                    pointRect = new PointRect(x, y, w, h);
                } else {
                    int h = sh;
                    int y = 0;
                    int w = (int)((float)sh * fScale);
                    int x = (sw - w) / 2;
                    pointRect = new PointRect(x, y, w, h);
                }
                PointRect srcRect = pointRect;
                fArray = TexCoordsUtil.INSTANCE.create(sw, sh, srcRect, array);
            }
        } else {
            fArray = TexCoordsUtil.INSTANCE.create(fw, fh, new PointRect(0, 0, fw, fh), array);
        }
        return fArray;
    }

    private final float[] transColor(int color) {
        float[] argb = new float[]{(float)(color >>> 24 & 0xFF) / 255.0f, (float)(color >>> 16 & 0xFF) / 255.0f, (float)(color >>> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f};
        return argb;
    }

    public MixRender(@NotNull MixAnimPlugin mixAnimPlugin) {
        Intrinsics.checkParameterIsNotNull((Object)mixAnimPlugin, (String)"mixAnimPlugin");
        this.mixAnimPlugin = mixAnimPlugin;
        this.vertexArray = new GlFloatArray();
        this.srcArray = new GlFloatArray();
        this.maskArray = new GlFloatArray();
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/tencent/qgame/animplayer/mix/MixRender$Companion;", "", "()V", "TAG", "", "animplayer_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

