/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qgame.animplayer.plugin;

import android.view.MotionEvent;
import com.tencent.qgame.animplayer.AnimConfig;
import com.tencent.qgame.animplayer.AnimPlayer;
import com.tencent.qgame.animplayer.mask.MaskAnimPlugin;
import com.tencent.qgame.animplayer.mix.MixAnimPlugin;
import com.tencent.qgame.animplayer.plugin.IAnimPlugin;
import com.tencent.qgame.animplayer.util.ALog;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \"2\u00020\u0001:\u0001\"B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0012\u001a\u0004\u0018\u00010\nJ\b\u0010\u0013\u001a\u0004\u0018\u00010\fJ\u000e\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0005\u001a\u00020\u0006J\u0006\u0010\u0019\u001a\u00020\u0018J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ\u0006\u0010\u001e\u001a\u00020\u0018J\u0006\u0010\u001f\u001a\u00020\u0018J\u0006\u0010 \u001a\u00020\u0018J\u0006\u0010!\u001a\u00020\u0018R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/tencent/qgame/animplayer/plugin/AnimPluginManager;", "", "player", "Lcom/tencent/qgame/animplayer/AnimPlayer;", "(Lcom/tencent/qgame/animplayer/AnimPlayer;)V", "decodeIndex", "", "frameDiffTimes", "frameIndex", "maskAnimPlugin", "Lcom/tencent/qgame/animplayer/mask/MaskAnimPlugin;", "mixAnimPlugin", "Lcom/tencent/qgame/animplayer/mix/MixAnimPlugin;", "getPlayer", "()Lcom/tencent/qgame/animplayer/AnimPlayer;", "plugins", "", "Lcom/tencent/qgame/animplayer/plugin/IAnimPlugin;", "getMaskAnimPlugin", "getMixAnimPlugin", "onConfigCreate", "config", "Lcom/tencent/qgame/animplayer/AnimConfig;", "onDecoding", "", "onDestroy", "onDispatchTouchEvent", "", "ev", "Landroid/view/MotionEvent;", "onLoopStart", "onRelease", "onRenderCreate", "onRendering", "Companion", "animplayer_release"})
public final class AnimPluginManager {
    private final MixAnimPlugin mixAnimPlugin;
    private final MaskAnimPlugin maskAnimPlugin;
    private final List<IAnimPlugin> plugins;
    private int frameIndex;
    private int decodeIndex;
    private int frameDiffTimes;
    @NotNull
    private final AnimPlayer player;
    private static final String TAG = "AnimPlayer.AnimPluginManager";
    private static final int DIFF_TIMES = 4;
    public static final Companion Companion = new Companion(null);

    @Nullable
    public final MixAnimPlugin getMixAnimPlugin() {
        return this.mixAnimPlugin;
    }

    @Nullable
    public final MaskAnimPlugin getMaskAnimPlugin() {
        return this.maskAnimPlugin;
    }

    public final int onConfigCreate(@NotNull AnimConfig config) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        ALog.INSTANCE.i(TAG, "onConfigCreate");
        Iterable $this$forEach$iv = this.plugins;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IAnimPlugin it = (IAnimPlugin)element$iv;
            boolean bl = false;
            int res = it.onConfigCreate(config);
            if (res == 0) continue;
            return res;
        }
        return 0;
    }

    public final void onRenderCreate() {
        ALog.INSTANCE.i(TAG, "onRenderCreate");
        this.frameIndex = 0;
        this.decodeIndex = 0;
        Iterable $this$forEach$iv = this.plugins;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IAnimPlugin it = (IAnimPlugin)element$iv;
            boolean bl = false;
            it.onRenderCreate();
        }
    }

    public final void onDecoding(int decodeIndex) {
        ALog.INSTANCE.d(TAG, "onDecoding decodeIndex=" + decodeIndex);
        this.decodeIndex = decodeIndex;
        Iterable $this$forEach$iv = this.plugins;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IAnimPlugin it = (IAnimPlugin)element$iv;
            boolean bl = false;
            it.onDecoding(decodeIndex);
        }
    }

    public final void onLoopStart() {
        ALog.INSTANCE.i(TAG, "onLoopStart");
        this.frameIndex = 0;
        this.decodeIndex = 0;
    }

    public final void onRendering() {
        if (this.decodeIndex > this.frameIndex + 1 || this.frameDiffTimes >= 4) {
            ALog.INSTANCE.i(TAG, "jump frameIndex= " + this.frameIndex + ",decodeIndex=" + this.decodeIndex + ",frameDiffTimes=" + this.frameDiffTimes);
            this.frameIndex = this.decodeIndex;
        }
        if (this.decodeIndex != this.frameIndex) {
            int n = this.frameDiffTimes;
            this.frameDiffTimes = n + 1;
        } else {
            this.frameDiffTimes = 0;
        }
        ALog.INSTANCE.d(TAG, "onRendering frameIndex=" + this.frameIndex);
        Iterable $this$forEach$iv = this.plugins;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IAnimPlugin it = (IAnimPlugin)element$iv;
            boolean bl = false;
            it.onRendering(this.frameIndex);
        }
        int n = this.frameIndex;
        this.frameIndex = n + 1;
    }

    public final void onRelease() {
        ALog.INSTANCE.i(TAG, "onRelease");
        Iterable $this$forEach$iv = this.plugins;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IAnimPlugin it = (IAnimPlugin)element$iv;
            boolean bl = false;
            it.onRelease();
        }
    }

    public final void onDestroy() {
        ALog.INSTANCE.i(TAG, "onDestroy");
        Iterable $this$forEach$iv = this.plugins;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IAnimPlugin it = (IAnimPlugin)element$iv;
            boolean bl = false;
            it.onDestroy();
        }
    }

    public final boolean onDispatchTouchEvent(@NotNull MotionEvent ev) {
        Intrinsics.checkParameterIsNotNull((Object)ev, (String)"ev");
        Iterable $this$forEach$iv = this.plugins;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IAnimPlugin it = (IAnimPlugin)element$iv;
            boolean bl = false;
            if (!it.onDispatchTouchEvent(ev)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public final AnimPlayer getPlayer() {
        return this.player;
    }

    public AnimPluginManager(@NotNull AnimPlayer player) {
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        this.player = player;
        this.mixAnimPlugin = new MixAnimPlugin(this.player);
        this.maskAnimPlugin = new MaskAnimPlugin(this.player);
        this.plugins = CollectionsKt.listOf((Object[])new IAnimPlugin[]{this.mixAnimPlugin, this.maskAnimPlugin});
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/tencent/qgame/animplayer/plugin/AnimPluginManager$Companion;", "", "()V", "DIFF_TIMES", "", "TAG", "", "animplayer_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

