/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qgame.animplayer.util;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.text.TextPaint;
import com.tencent.qgame.animplayer.mix.Src;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004J\u000e\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/tencent/qgame/animplayer/util/BitmapUtil;", "", "()V", "createEmptyBitmap", "Landroid/graphics/Bitmap;", "createTxtBitmap", "src", "Lcom/tencent/qgame/animplayer/mix/Src;", "animplayer_release"})
public final class BitmapUtil {
    public static final BitmapUtil INSTANCE;

    @NotNull
    public final Bitmap createEmptyBitmap() {
        Bitmap bitmap = Bitmap.createBitmap((int)16, (int)16, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        boolean bl = false;
        boolean bl2 = false;
        Bitmap $this$apply = bitmap;
        boolean bl3 = false;
        $this$apply.eraseColor(0);
        Bitmap bitmap2 = bitmap;
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap2, (String)"Bitmap.createBitmap(16, \u2026or.TRANSPARENT)\n        }");
        return bitmap2;
    }

    @NotNull
    public final Bitmap createTxtBitmap(@NotNull Src src) {
        Intrinsics.checkParameterIsNotNull((Object)src, (String)"src");
        int w = src.getW();
        int h = src.getH();
        Bitmap bitmap = Bitmap.createBitmap((int)w, (int)h, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        Rect rect = new Rect(0, 0, w, h);
        Rect bounds = new Rect();
        float sizeR = 0.8f;
        TextPaint textPaint = new TextPaint();
        boolean bl = false;
        boolean bl2 = false;
        TextPaint $this$apply = textPaint;
        boolean bl3 = false;
        $this$apply.setTextSize((float)h * sizeR);
        $this$apply.setTextAlign(Paint.Align.CENTER);
        $this$apply.setStyle(Paint.Style.FILL);
        $this$apply.setAntiAlias(true);
        if (src.getStyle() == Src.Style.BOLD) {
            $this$apply.setTypeface(Typeface.create((Typeface)Typeface.DEFAULT, (int)1));
        }
        $this$apply.setColor(src.getColor());
        TextPaint paint = textPaint;
        String text = src.getTxt();
        while (sizeR > 0.1f) {
            paint.getTextBounds(text, 0, text.length(), bounds);
            if (bounds.width() <= rect.width()) break;
            paint.setTextSize((float)h * (sizeR -= 0.1f));
        }
        Paint.FontMetricsInt fontMetrics = paint.getFontMetricsInt();
        int top = fontMetrics.top;
        int bottom = fontMetrics.bottom;
        int baseline = rect.centerY() - top / 2 - bottom / 2;
        canvas.drawText(text, (float)rect.centerX(), (float)baseline, (Paint)paint);
        Bitmap bitmap2 = bitmap;
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap2, (String)"bitmap");
        return bitmap2;
    }

    private BitmapUtil() {
    }

    static {
        BitmapUtil bitmapUtil;
        INSTANCE = bitmapUtil = new BitmapUtil();
    }
}

