/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qgame.animplayer.util;

import android.graphics.Bitmap;
import android.opengl.GLES20;
import android.opengl.GLUtils;
import com.tencent.qgame.animplayer.util.ALog;
import kotlin.Metadata;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bJ\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/tencent/qgame/animplayer/util/TextureLoadUtil;", "", "()V", "TAG", "", "loadTexture", "", "bitmap", "Landroid/graphics/Bitmap;", "releaseTexure", "", "textureId", "animplayer_release"})
public final class TextureLoadUtil {
    private static final String TAG = "TextureUtil";
    public static final TextureLoadUtil INSTANCE;

    public final int loadTexture(@Nullable Bitmap bitmap) {
        int[] textureObjectIds = new int[1];
        GLES20.glGenTextures((int)1, (int[])textureObjectIds, (int)0);
        if (textureObjectIds[0] == 0) {
            return 0;
        }
        if (bitmap == null) {
            GLES20.glDeleteTextures((int)1, (int[])textureObjectIds, (int)0);
            return 0;
        }
        if (bitmap.isRecycled()) {
            ALog.INSTANCE.e(TAG, "bitmap isRecycled");
            return 0;
        }
        GLES20.glBindTexture((int)3553, (int)textureObjectIds[0]);
        GLES20.glTexParameteri((int)3553, (int)10241, (int)9987);
        GLES20.glTexParameteri((int)3553, (int)10240, (int)9729);
        GLUtils.texImage2D((int)3553, (int)0, (Bitmap)bitmap, (int)0);
        GLES20.glGenerateMipmap((int)3553);
        GLES20.glBindTexture((int)3553, (int)0);
        return textureObjectIds[0];
    }

    public final void releaseTexure(int textureId) {
        if (textureId != 0) {
            GLES20.glDeleteTextures((int)1, (int[])new int[]{textureId}, (int)0);
        }
    }

    private TextureLoadUtil() {
    }

    static {
        TextureLoadUtil textureLoadUtil;
        INSTANCE = textureLoadUtil = new TextureLoadUtil();
    }
}

