/*
 * Decompiled with CFR 0.152.
 */
package com.testsigma.restapi;

import java.io.File;
import java.net.URI;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;

public class TestsigmaConnector {
    private static final String _SERVER_URL = "https://app.testsigma.com";
    private static final String REST_END_POINT_CF = "/api/v1/custom_functions";
    private static final String REST_END_POINT_PROJECT = "/api/v1/projects/%s/id";

    public void addCustomFunctions(String apiKey, String testsigmaProjectName, String[] javaFilePaths) throws Exception {
        String projectId = this.getProjectId(apiKey, testsigmaProjectName);
        if (projectId == null) {
            throw new Exception("Unable to fetch ProjectId, Please verify the given project name is available, Project:" + testsigmaProjectName);
        }
        for (String javaFilePath : javaFilePaths) {
            System.out.println("***********Adding custom function " + javaFilePath + "***************");
            HttpEntity multiPartBody = this.prepareMultipartEntity(javaFilePath, projectId);
            CloseableHttpClient httpClient = HttpClientBuilder.create().build();
            HttpPost postRequest = new HttpPost("https://app.testsigma.com/api/v1/custom_functions");
            this.setHeaders((HttpRequestBase)postRequest, apiKey);
            postRequest.setEntity(multiPartBody);
            HttpResponse res = httpClient.execute((HttpUriRequest)postRequest);
            String body = EntityUtils.toString((HttpEntity)res.getEntity());
            System.out.println("Add custom function Response:" + res.getStatusLine());
            System.out.println("Response Body:" + body);
            System.out.println("***********Adding custom function End ***************");
        }
    }

    public void updateCustomFunctions(String apiKey, String testsigmaProjectName, String[] javaFilePaths) throws Exception {
        String projectId = this.getProjectId(apiKey, testsigmaProjectName);
        if (projectId == null) {
            throw new Exception("Unable to fetch ProjectId, Please verify the given project name is available, Project:" + testsigmaProjectName);
        }
        for (String javaFilePath : javaFilePaths) {
            File javaFile = new File(javaFilePath);
            String fileName = javaFile.getName();
            String fileId = this.getFileId(apiKey, projectId, fileName.substring(0, fileName.indexOf(".")));
            System.out.println("***********Updating custom function " + javaFilePath + "***************");
            HttpEntity multiPartBody = this.prepareMultipartEntity(javaFilePath, projectId);
            CloseableHttpClient httpClient = HttpClientBuilder.create().build();
            HttpPut putRequest = new HttpPut("https://app.testsigma.com/api/v1/custom_functions/" + fileId);
            this.setHeaders((HttpRequestBase)putRequest, apiKey);
            putRequest.setEntity(multiPartBody);
            HttpResponse res = httpClient.execute((HttpUriRequest)putRequest);
            String body = EntityUtils.toString((HttpEntity)res.getEntity());
            System.out.println("Update custom function Response:" + res.getStatusLine());
            System.out.println("Response Body:" + body);
            System.out.println("***********Updating custom function End ***************");
        }
    }

    private HttpEntity prepareMultipartEntity(String filePath, String projectId) {
        File javaFile = new File(filePath);
        MultipartEntityBuilder entityBuilder = MultipartEntityBuilder.create();
        entityBuilder.addBinaryBody("javaFile", javaFile);
        HttpEntity dataEntity = entityBuilder.addTextBody("projectId", String.valueOf(projectId)).build();
        return dataEntity;
    }

    public String getProjectId(String apiKey, String projectName) throws Exception {
        projectName = projectName.replaceAll(" ", "%20");
        String url = _SERVER_URL + String.format(REST_END_POINT_PROJECT, projectName);
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HttpGet getRequest = new HttpGet(new URI(url));
        this.setHeaders((HttpRequestBase)getRequest, apiKey);
        HttpResponse res = httpClient.execute((HttpUriRequest)getRequest);
        System.out.println("Project API Status:" + res.getStatusLine());
        int statusCode = res.getStatusLine().getStatusCode();
        if (statusCode != 200) {
            throw new Exception("Unable to get project details, please verify project name and API key.");
        }
        return EntityUtils.toString((HttpEntity)res.getEntity());
    }

    public String getFileId(String apiKey, String projectId, String className) throws Exception {
        String url = String.format("%s%s/%s/%s", _SERVER_URL, REST_END_POINT_CF, projectId, className);
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HttpGet getRequest = new HttpGet(url);
        this.setHeaders((HttpRequestBase)getRequest, apiKey);
        HttpResponse res = httpClient.execute((HttpUriRequest)getRequest);
        System.out.println("Fetching custom function details status:" + res.getStatusLine());
        int statusCode = res.getStatusLine().getStatusCode();
        if (statusCode != 200) {
            throw new Exception("Unable to get Custom function, please verify if custom function is available in given project.");
        }
        return EntityUtils.toString((HttpEntity)res.getEntity());
    }

    public static void main(String[] a) throws Exception {
        String key = "eyJhbGciOiJIUzUxMiJ.n3BhuE0sp0DAoGluxdMpc0ex5eNATVnEeA-DT-NzL_YSWfniLEWYK7aLrS-FhYUD1kO0MQu9renQ0p-oyCXMlQ";
        TestsigmaConnector con = new TestsigmaConnector();
        String fileID = con.getFileId(key, con.getProjectId(key, "TestProj"), "CustomFunc1");
        String[] files = new String[]{"/Users/work/projects/src/main/java/CustomFunc1.java"};
        con.updateCustomFunctions(key, "LambdaTest", files);
    }

    private void setHeaders(HttpRequestBase getRequest, String key) {
        if (key != null) {
            getRequest.setHeader("Authorization", "Bearer " + key);
        } else {
            System.out.println("api key cannot be null, you can generate Apikey by logging into app.testsigma.com");
        }
    }
}

