/*
 * Decompiled with CFR 0.152.
 */
package org.tbk.nostr.base;

import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.ByteString;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HexFormat;
import java.util.Iterator;
import java.util.stream.IntStream;
import org.tbk.nostr.proto.EventOrBuilder;

public final class EventId
implements Comparable<EventId> {
    private static final SecureRandom RANDOM = new SecureRandom();
    private final byte[] raw;
    private static final int UNSIGNED_BYTE_MASK = 255;
    private static final Comparator<byte[]> UNSIGNED_LEXICOGRAPHICAL_COMPARATOR = (former, latter) -> {
        Iterator formerBytes = IntStream.range(0, ((byte[])former).length).mapToObj(it -> former[it]).iterator();
        Iterator latterBytes = IntStream.range(0, ((byte[])latter).length).mapToObj(it -> latter[it]).iterator();
        while (formerBytes.hasNext() && latterBytes.hasNext()) {
            int result = Integer.compare(EventId.toInt((Byte)formerBytes.next()), EventId.toInt((Byte)latterBytes.next()));
            if (result == 0) continue;
            return result;
        }
        return Integer.compare(((byte[])former).length, ((byte[])latter).length);
    };

    public static boolean isValidEventIdString(String value) {
        if (value.length() != 64) {
            return false;
        }
        try {
            return HexFormat.of().parseHex(value).length == 32;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static EventId fromHex(String id) {
        return EventId.of(HexFormat.of().parseHex(id));
    }

    public static EventId of(EventOrBuilder eventOrBuilder) {
        return EventId.of(eventOrBuilder.getId());
    }

    public static EventId of(ByteString id) {
        return EventId.of(id.toByteArray());
    }

    public static EventId of(byte[] id) {
        return new EventId(id);
    }

    @VisibleForTesting
    public static EventId random() {
        byte[] bytes = new byte[32];
        RANDOM.nextBytes(bytes);
        return EventId.of(bytes);
    }

    private EventId(byte[] raw) {
        if (raw.length != 32) {
            throw new IllegalArgumentException("Event id must have length of 32 bytes");
        }
        this.raw = Arrays.copyOf(raw, raw.length);
    }

    public byte[] toByteArray() {
        return Arrays.copyOf(this.raw, this.raw.length);
    }

    public String toHex() {
        return HexFormat.of().formatHex(this.raw);
    }

    @Override
    public int compareTo(EventId o) {
        return UNSIGNED_LEXICOGRAPHICAL_COMPARATOR.compare(this.raw, o.raw);
    }

    public String toString() {
        return "EventId[%s]".formatted(this.toHex());
    }

    private static int toInt(byte value) {
        return value & 0xFF;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EventId)) {
            return false;
        }
        EventId other = (EventId)o;
        return Arrays.equals(this.raw, other.raw);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.hashCode(this.raw);
        return result;
    }
}

